% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_intersection.r
\name{has_intersection}
\alias{has_intersection}
\alias{has_intersection.default}
\alias{has_intersection.Point1D}
\alias{has_intersection.Line2D}
\alias{has_intersection.Plane3D}
\title{Whether two objects intersect}
\usage{
has_intersection(x, y, ...)

\method{has_intersection}{default}(x, y, ...)

\method{has_intersection}{Point1D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{has_intersection}{Line2D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))

\method{has_intersection}{Plane3D}(x, y, ..., tolerance = sqrt(.Machine$double.eps))
}
\arguments{
\item{x, y}{The two objects to check if they intersect.}

\item{...}{Passed to other methods (or ignored).}

\item{tolerance}{Numerics with differences smaller
than \code{tolerance} will be considered \dQuote{equivalent}.}
}
\value{
A logical vector.
}
\description{
\code{has_intersection()} is an S3 method that returns whether two objects intersect.
}
\details{
\code{affiner::has_intersection()} has the same S3 signature and default method as
\code{euclid::has_intersection()} (so it shouldn't matter if one masks the other).
}
\examples{
line1 <- as_line2d("x-axis")
line2 <- as_line2d("y-axis")
line3 <- as_line2d(a = 0, b = 1, c = 2) # y + 2 = 0
has_intersection(line1, line1)
has_intersection(line1, line2)
has_intersection(line1, line3)
}
