% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle.r
\name{angle-methods}
\alias{angle-methods}
\alias{as.double.angle}
\alias{as.complex.angle}
\alias{format.angle}
\alias{print.angle}
\alias{abs.angle}
\title{Implemented base methods for angle vectors}
\usage{
\method{as.double}{angle}(x, unit = angular_unit(x), ...)

\method{as.complex}{angle}(x, modulus = 1, ...)

\method{format}{angle}(x, unit = angular_unit(x), ..., use_unicode = is_utf8_output())

\method{print}{angle}(x, unit = angular_unit(x), ..., use_unicode = is_utf8_output())

\method{abs}{angle}(x)
}
\arguments{
\item{x}{\code{\link[=angle]{angle()}} vector}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}

\item{...}{Passed to \code{\link[=print.default]{print.default()}}}

\item{modulus}{Numeric vector representing the complex numbers' modulus}

\item{use_unicode}{If \code{TRUE} use Unicode symbols as appropriate.}
}
\value{
Typical values as usually returned by these base generics.
}
\description{
We implemented methods for several base generics for the \code{\link[=angle]{angle()}} vectors.
}
\details{
\itemize{
\item Mathematical \link{Ops} (in particular \code{+} and \code{-})
for two angle vectors will (if necessary)
set the second vector's \code{\link[=angular_unit]{angular_unit()}} to match the first.
\item \code{\link[=as.numeric]{as.numeric()}} takes a \code{unit} argument which can be used to convert angles into other angular units
e.g. \code{angle(x, "degrees") |> as.numeric("radians")} to cast a numeric vector \code{x} from degrees to radians.
\item \code{\link[=abs]{abs()}} will calculate the angle modulo full turns.
\item Use \code{\link[=is_congruent]{is_congruent()}} to test if two angles are congruent instead of \code{==} or \code{all.equal()}.
\item Not all implemented methods are documented here and since \code{\link[=angle]{angle()}} is a
\code{\link[=numeric]{numeric()}} class many other S3 generics
besides the explicitly implemented ones should also work with it.
}
}
\examples{
  # Two "congruent" angles
  a1 <- angle(180, "degrees")
  a2 <- angle(pi, "radians")

  print(a1)
  print(a1, unit = "radians")
  print(a1, unit = "pi-radians")

  cos(a1)
  sin(a1)
  tan(a1)

  # mathematical operations will coerce second `angle()` object to
  # same `angular_unit()` as the first one
  a1 + a2
  a1 - a2

  as.numeric(a1)
  as.numeric(a1, "radians")
  as.numeric(a1, "turns")

  # Use `is_congruent()` to check if two angles are "congruent"
  a1 == a2
  isTRUE(all.equal(a1, a2))
  is_congruent(a1, a2)
  is_congruent(a1, a2, mod_turns = FALSE)
  a3 <- angle(-180, "degrees") # Only congruent modulus full turns
  a1 == a3
  isTRUE(all.equal(a1, a2))
  is_congruent(a1, a3)
  is_congruent(a1, a3, mod_turns = FALSE)

}
