% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{adj_matrix}
\alias{adj_matrix}
\alias{adj_from_matrix}
\alias{as.matrix.adj}
\title{Convert adjacency lists to and from adjacency matrices}
\usage{
adj_from_matrix(
  x,
  duplicates = c("warn", "error", "allow", "remove"),
  self_loops = c("warn", "error", "allow", "remove")
)

\method{as.matrix}{adj}(x, sparse = FALSE, ...)
}
\arguments{
\item{x}{An adjacency list or matrix}

\item{duplicates}{Controls handling of duplicate neighbors. The value
\code{"warn"} warns the user; \code{"error"} throws an error; \code{"allow"} allows
duplicates, and \code{"remove"} removes duplicates silently and then sets the
corresponding attribute to \code{"error"}.}

\item{self_loops}{Controls handling of self-loops (nodes that are adjacent
to themselves). The value \code{"warn"} warns the user; \code{"error"} throws an
error; \code{"allow"} allows self-loops, and \code{"remove"} removes self-loops
silently and then sets the corresponding attribute to \code{"error"}.}

\item{sparse}{If \code{TRUE}, return a sparse matrix, which is often preferable
for computation. See \link[Matrix:sparseMatrix]{Matrix::sparseMatrix} for details on this class.}

\item{...}{Ignored.}
}
\value{
\code{adj_from_matrix()} returns an \code{adj} list; \code{as.matrix()} returns a matrix.
}
\description{
Adjacency lists can be converted to adjacency matrices and vice versa without
loss.
}
\examples{
adj_from_matrix(1 - diag(3))

a = adj(konigsberg$bridge_to, ids = konigsberg$area, duplicates = "allow")
mat = as.matrix(a)
all(a == adj_from_matrix(mat, duplicates = "allow")) # TRUE
}
