% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{adj_indexing}
\alias{adj_indexing}
\alias{[.adj}
\alias{c.adj}
\title{Indexing operations on adjacency lists}
\usage{
\method{[}{adj}(x, i, ...)

\method{c}{adj}(...)
}
\arguments{
\item{x}{An adjacency list of class \code{adj}}

\item{i}{Indexing vector}

\item{...}{For \code{c()}, adjacency lists to concatenate. Ignored for \code{[}.}
}
\value{
A reindexed adjacency list for \code{[}, and a concatenated adjacency list for \code{c()}.
}
\description{
\code{adj} overrides the default \code{[} and \code{c()} methods to allow for filtering,
reordering, and concatenating adjacency lists while ensuring that indices
remain internally consistent.
}
\details{
When duplicate indices are present in the adjacency list, indexing is
performed by slicing the adjacency matrix, which is slower and requires
more memory. For large adjacency lists, slicing with duplicates will
error for this reason; set \code{options(adj.max_matrix_slice = Inf)} to allow it,
but be aware of the possible memory usage implications.
}
\examples{
a <- adj(c(2, 3), c(1, 3), c(1, 2))
a[1:2]
all(sample(a) == a) # any permutation yields the same graph

a <- adj(konigsberg$bridge_to, ids = konigsberg$area, duplicates = "remove")
c(a, a) # concatenates graphs with no connecting edges
}
