% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_stratified_analysis_bulk.R
\name{identify_sex_specific_genes}
\alias{identify_sex_specific_genes}
\title{Identify sex-specific and sex-dimorphic genes}
\usage{
identify_sex_specific_genes(
  male_results,
  female_results,
  target_fdr = 0.05,
  exclude_fdr = 0.5
)
}
\arguments{
\item{male_results}{Data frame of differential expression results for males (from differential_expression).}

\item{female_results}{Data frame of differential expression results for females (from differential_expression).}

\item{target_fdr}{Numeric. FDR threshold for significant differential expression (default: 0.05).}

\item{exclude_fdr}{Numeric. FDR threshold for excluding effects in the opposite sex (default: 0.5).}
}
\value{
A data frame with identified genes categorized as:
        - male-specific: significant in males, not significant in females
        - female-specific: significant in females, not significant in males
        - sex-dimorphic: significant in both sexes with opposite effects
        - sex-shared: significant in both sexes with same direction
        Including columns for gene IDs, logFC values, and FDR values for both sexes.
}
\description{
This function identifies truly sex-specific and sex-dimorphic genes by analyzing
differential expression results from both sexes.
}
\details{
This function implements a two-step approach to identify sex-specific effects:
         1. Identifies genes significantly affected in one sex (target_fdr)
         2. Confirms lack of effect in the other sex (exclude_fdr)
         Additionally identifies genes with opposite (dimorphic) or same (shared) effects in both sexes.
}
