% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_functions.R
\name{generate_validation}
\alias{generate_validation}
\title{Validate forecast performance over multiple time windows}
\usage{
generate_validation(
  data,
  start_date,
  validate_window_size = 7,
  window_size = 7,
  n_days = 7,
  type = NULL,
  smooth_data = FALSE,
  smoothing_cutoff = 10,
  ...
)
}
\arguments{
\item{data}{A data frame containing at least the columns \code{"date"} and
\code{"confirm"}. The \code{"date"} column should be of class \code{Date}, and
\code{"confirm"} should be numeric.}

\item{start_date}{A \code{Date} (or date-convertible string) specifying the
starting point for validation Must exist in the \code{"date"} column.}

\item{validate_window_size}{Integer. The number of days between each
validation window (default: \code{7}).}

\item{window_size}{Integer. The sliding window size (in days) used by the
forecasting model (default: \code{7}).}

\item{n_days}{Integer. The number of future days to forecast in each
validation iteration (default: \code{7}).}

\item{type}{\emph{character}
Type of epidemic. Must be one of \code{"flu_a"}, \code{"flu_b"}, \code{"rsv"},
\code{"sars_cov2"}, or \code{"custom"}. Passed to
\code{\link{fit_epiestim_model}}.}

\item{smooth_data}{Logical. Whether to smooth the input case counts prior
to forecasting (default: \code{FALSE}).}

\item{smoothing_cutoff}{Numeric. Threshold used for smoothing when
\code{smooth_data = TRUE} (default: \code{10}).}

\item{...}{Additional arguments passed to \code{generate_forecast()}.}
}
\value{
A list of forecast results, each element corresponding to one
validation window. Each element contains the output returned by
\code{generate_forecast()} for that particular window.
}
\description{
This function performs rolling validation of short-term forecasts generated
by \strong{EpiEstim} or similar models. It divides the input time series into
overlapping validation windows and repeatedly runs forecasts to assess model
performance across different time segments.
}
\details{
The validation procedure ensures that forecasts are evaluated under realistic
temporal conditions. Starting from the earliest date, the function repeatedly:
\enumerate{
\item Takes a growing subset of data up to the current validation endpoint.
\item Runs the forecast using \code{generate_forecast()}.
\item Moves the validation window forward by \code{validate_window_size} days.
}

This results in a set of forecasts that can be compared to observed data to
evaluate predictive performance across time.
}
\examples{
data <- simulate_data()
formatted_data <- get_aggregated_data(data,"date", "flu_a", "2024-10-16", "2024-12-31")
start_date <- as.Date("2024-10-16")
validation_results <- generate_validation(formatted_data, start_date, type="flu_a")

}
\seealso{
\code{\link[=clean_sample_data]{clean_sample_data()}}, \code{\link[=generate_forecast]{generate_forecast()}}
}
