% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_glm.R
\name{glm.best}
\alias{glm.best}
\title{Title: Fitting generalized linear models for the best model}
\usage{
glm.best(
  object,
  family,
  method = "models",
  threshold = 0.95,
  x = FALSE,
  y = FALSE
)
}
\arguments{
\item{object}{the model selection result from \code{modelselect.glm}.}

\item{family}{a character string naming a family function describing the error distribution to be used in the model.}

\item{method}{the criteria to do model select.
\code{method = "models"} selects the best model by the highest posterior probabilities.
\code{method = "variables"} selects the variables in the best model by the posterior inclusion probabilities which are larger than the threshold.}

\item{threshold}{The threshold for variable selection. The variables with posterior inclusion probability larger than the threshold are selected in the best model. The default is 0.95.}

\item{x, y}{logicals. If \code{TRUE} the corresponding components (the best model predictor matrix, the response) of the fit are returned.}
}
\value{
An object of class \code{"glm"}, which is a list containing the following components:
\describe{
\item{\code{coefficients}}{a named vector of coefficients.}
\item{\code{residuals}}{the working residuals, that is the residuals in the final iteration of the IWLS fit.}
\item{\code{fitted.values}}{the fitted mean values, obtained by transforming the linear predictors by the inverse of the link function.}
\item{\code{rank}}{the numeric rank of the fitted linear model.}
\item{\code{family}}{the family object used.}
\item{\code{linear.predictors}}{the linear fit on the link scale.}
\item{\code{deviance}}{up to a constant, minus twice the maximized log-likelihood.}
\item{\code{aic}}{A version of Akaike's An Information Criterion, minus twice the maximized log-likelihood plus twice the number of parameters, computed by the \code{aic} component of the family.}
\item{\code{null.deviance}}{The deviance for the null model, comparable with \code{deviance}. The null model will include the offset, and an intercept if there is one in the model.}
\item{\code{iter}}{the number of iterations of IWLS used.}
\item{\code{weights}}{the working weights, that is the weights in the final iteration of the IWLS fit.}
\item{\code{prior.weights}}{the weights initially supplied, a vector of 1s if none were.}
\item{\code{df.residual}}{the residual degrees of freedom.}
\item{\code{df.null}}{the residual degrees of freedom for the null model.}
\item{\code{y}}{if requested, the response vector used.}
\item{\code{converged}}{logical. Was the IWLS algorithm judged to have converged?}
\item{\code{boundary}}{logical. Is the fitted value on the boundary of the allowable values?}
\item{\code{model}}{if requested (the default), the model frame used.}
\item{\code{call}}{the matched call.}
\item{\code{formula}}{the formula supplied.}
\item{\code{terms}}{the \code{\link{terms.object}} used.}
\item{\code{data}}{the data argument.}
\item{\code{threshold}}{the threshold used for method = "variables".}
}
}
\description{
Description: \code{glm.best} is used to fit generalized linear model for the best model provided by \code{modelselect.glm}.
}
