% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coreVertex.R
\name{coreVertex}
\alias{coreVertex}
\title{Vertices of the core of the game}
\usage{
coreVertex(
  characteristic_func,
  n_players = 0,
  method = "exact",
  n_rep = 1000,
  echo = TRUE
)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}

\item{method}{Method used to calculate the core. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated core
based on Camacho et al. (2025).}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{echo}{Only used if \code{method} is \code{appro}. Show progress of the
approximated calculation.}
}
\value{
The vertices of the core if it exists.
}
\description{
Calculate the vertices of core of the game if it exits.
}
\examples{
v <- c(2,3,5,5,7,8,10)
coreVertex(v, method = "exact")
coreVertex(v, method = "appro", n_rep = 100)

n <- 3
v <- function(coalition) {
 size <- length(coalition)
 if (size <= 1) {
   return(0)
 } else if (size == 2) {
   return(10)
 } else if (size == 3) {
   return(24)
 } else {
   return(0)
 }
}
coreVertex(v, n, method = "exact")
coreVertex(v, n, method = "appro", n_rep = 200)

}
\references{
Camacho, J., Gonçalves-Dosantos, J. C., & Sánchez-Soriano, J. (2025).
A Linear Programming Approach to Estimate the Core in Cooperative Games.
arXiv preprint arXiv:2510.01766.
}
