ICAtestRankvdW_jade_par <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  n <- nrow(X)
  T.W <- TmW_Gauss(VdW(ICA$S))
  
  # Set up parallel environment
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("VdW", "bootZjade", "TmW_Gauss", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    # Using parSapply to run the bootstrap in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(VdW(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    stopCluster(cl)
  } else {
    # Fallback to non-parallel execution if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_jade_par <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "bootZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    # Using parSapply to run the bootstrap in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(bootZjade(ICA$S, eps = eps, maxiter = maxiter))
    })
    
    # Stop the cluster
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_fobi_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  # Perform FOBI on the original data
  ICA <- FOBI(X)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "bootZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(bootZfobi(ICA$S))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(bootZfobi(ICA$S)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_fICA_par <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  # Perform FastICA on the original data
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  T.W <- TmW_Gauss(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "bootZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestGauss_S_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  T.W <- TmW_Gauss(S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "bootS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(scale(bootS(S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(scale(bootS(S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL)
  return(RES)
}

ICAtestLap_jade_par <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "bootZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(bootZjade(ICA$S, eps = eps, maxiter = maxiter))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Lap(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestLap_fobi_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "bootZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(bootZfobi(ICA$S))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Lap(bootZfobi(ICA$S)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestLap_fICA_par <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  T.W <- TmW_Lap(ICA$S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "bootZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Lap(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}



ICAtestLap_S_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  T.W <- TmW_Lap(S)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Lap", "bootS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(scale(bootS(S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Lap(scale(bootS(S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL)
  return(RES)
}


ICAtestRankGauss_jade_par <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "bootZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_fobi_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "bootZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(RANKS(bootZfobi(ICA$S)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZfobi(ICA$S))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_fICA_par <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "bootZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(RANKS(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(RANKS(bootZfICA(ICA$S, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankGauss_S_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Gauss(R)
  
  # Set up parallel environment if more than one core is specified
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    # Export necessary variables and functions to the cluster
    clusterExport(cl, varlist = c("TmW_Gauss", "RANKS", "bootS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)  # Set RNG stream for reproducibility
    
    # Use parSapply to perform the bootstrapping in parallel
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(RANKS(scale(bootS(S))))
    })
    
    # Stop the cluster after use
    stopCluster(cl)
  } else {
    # Fallback to sequential processing if no cores are specified
    Tboot <- replicate(n.boot, TmW_Gauss(RANKS(scale(bootS(S)))))
  }
  
  # Calculate the p-value
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  
  # Return the results
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL)
  return(RES)
}


ICAtestRankLap_jade_par <- function(X, n.boot = 200, eps = 1e-06, maxiter = 100, ncores = NULL, iseed = NULL) {
  ICA <- JADE(X, eps = eps, maxiter = maxiter)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "bootZjade", "ICA", "eps", "maxiter", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter)))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZjade(ICA$S, eps = eps, maxiter = maxiter))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankLap_fobi_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "bootZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(RANKS(bootZfobi(ICA$S)))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZfobi(ICA$S))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankLap_fICA_par <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- RANKS(ICA$S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "bootZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(RANKS(bootZfICA(ICA$S, g, method, inR, maxiter, n.init, eps)))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Lap(RANKS(bootZfICA(ICA$S, g, method, inR, maxiter, n.init, eps))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestRankLap_S_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- RANKS(S)
  T.W <- TmW_Lap(R)
  
  # Setup parallel
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Lap", "RANKS", "bootS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Lap(RANKS(scale(bootS(S))))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Lap(RANKS(scale(bootS(S)))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL)
  return(RES)
}




ICAtestRankvdW_fobi_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  ICA <- FOBI(X)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "bootZfobi", "ICA", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(VdW(bootZfobi(ICA$S)))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZfobi(ICA$S))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}


ICAtestRankvdW_fICA_par <- function(X, n.boot = 200, g = "tanh", method = "sym", inR = FALSE, maxiter = 500, eps=1e-06, n.init=2, ncores = NULL, iseed = NULL) {
  ICA <- fICA(X, g = g, method = method, inR = inR, maxiter = maxiter, n.init = n.init, eps = eps)
  R <- VdW(ICA$S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "bootZfICA", "ICA", "g", "method", "inR", "maxiter", "n.init", "eps", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(VdW(bootZfICA(ICA$S, g, method, inR, maxiter, n.init, eps)))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Gauss(VdW(bootZfICA(ICA$S, g, method, inR, maxiter, n.init, eps))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL, ICA = ICA)
  return(RES)
}

ICAtestRankvdW_S_par <- function(X, n.boot = 200, ncores = NULL, iseed = NULL) {
  S <- scale(X)
  R <- VdW(S)
  T.W <- TmW_Gauss(R)
  
  if (!is.null(ncores) && ncores > 1) {
    cl <- makeCluster(ncores, type = "PSOCK")
    clusterExport(cl, varlist = c("TmW_Gauss", "VdW", "bootS", "S", "iseed"), envir = environment())
    clusterSetRNGStream(cl, iseed)
    
    Tboot <- parSapply(cl, seq_len(n.boot), function(i) {
      TmW_Gauss(VdW(scale(bootS(S))))
    })
    stopCluster(cl)
  } else {
    Tboot <- replicate(n.boot, TmW_Gauss(VdW(scale(bootS(S)))))
  }
  
  PVAL <- (sum(T.W < Tboot) + 1) / (n.boot + 1)
  RES <- list(T = T.W, Tboot = Tboot, pval = PVAL)
  return(RES)
}
