% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFORGE-package.R
\docType{package}
\name{TFORGE-package}
\alias{TFORGE}
\alias{TFORGE-package}
\title{TFORGE: Tests for Geophysical Eigenvalues}
\description{
The eigenvalues of observed symmetric matrices are often of intense scientific interest. This package offers single sample tests for the eigenvalues of the population mean or the eigenvalue-multiplicity of the population mean. For k-samples, this package offers tests for equal eigenvalues between samples. Included is support for matrices with constraints common to geophysical tensors (constant trace, sum of squared eigenvalues, or both) and eigenvectors are usually considered nuisance parameters. Pivotal bootstrap methods enable these tests to have good performance for small samples (n=15 for 3x3 matrices). These methods were developed and studied by Hingee, Scealy and Wood (2026, "Nonparametric bootstrap inference for the eigenvalues of geophysical tensors", accepted by the Journal of American Statistical Association). Also available is a 2-sample test using a Gaussian orthogonal ensemble approximation and an eigenvalue-multiplicity test that assumes orthogonally-invariant covariance.
}
\details{
All tests in this package are for hypotheses about the eigenvalues of the (extrinsic) mean of the sampled population(s).
Functions for conducting hypothesis tests start with \code{test_}.
When the matrices are constrained to a submanifold of the space of symmetric matrices we use the extrinsic mean, which projects the usual linear/Euclidean mean so that it satisfies the same constraints as the data.
Tests can be calibrated using either a chi-squared distribution or bootstrapping; in simulations bootstrapping was more reliable but slower.

The following functions conduct single sample and \eqn{k}-sample tests of the eigenvalues of the (extrinsic) population mean:
\itemize{
\item \code{\link[=test_unconstrained]{test_unconstrained()}}
\item \code{\link[=test_fixedtrace]{test_fixedtrace()}} when matrices have fixed trace
\item \code{\link[=test_ss1]{test_ss1()}} when the squared eigenvalues of each matrix sums to \eqn{1}.
\item \code{\link[=test_ss1fixedtrace]{test_ss1fixedtrace()}} when the squared eigenvalues of each matrix sums to \eqn{1} and the trace is zero.
}

The single sample tests conducted by the above functions test the null hypothesis of a user-provided set of eigenvalues for the extrinsic population mean against the alternative hypothesis that the extrinsic population mean has different eigenvalues.
The \eqn{k}-sample tests conducted by the above functions test the null hypothesis that the extrinsic population means have the same eigenvalues.

Additionally \code{\link[=test_unconstrained_aGOE]{test_unconstrained_aGOE()}} can perform \eqn{2}-sample tests with calibration by a Gaussian Orthogonal Ensemble (GOE) approximation \insertCite{schwartzman2010gr}{TFORGE}. A bootstrapped calibration for this test is also available where the GOE approximation is used to stabilise the scale of the statistic.

There are two functions \code{\link[=conf_fixedtrace]{conf_fixedtrace()}} and \code{\link[=conf_ss1fixedtrace]{conf_ss1fixedtrace()}} for estimating confidence regions.

The above tests all require that the eigenvalues of the population mean are distinct (with degraded performance when eigenvalues are very close to each other).
Eigenvalues are assumed to be in descending order.

Use \code{\link[=test_multiplicity]{test_multiplicity()}} to test the eigenvalue-multiplicity of the population mean of a single sample.
A test of the same hypothesis that requires that matrix elements follow a multivariate Gaussian distribution with orthogonally-invariant covariance is also available through \code{\link[=test_multiplicity_OI]{test_multiplicity_OI()}} \insertCite{schwartzman2008in}{TFORGE}.
\code{\link[=test_multiplicity]{test_multiplicity()}} can also be applied to matrices with a constrained trace, but use \code{\link[=test_multiplicity_nonnegative]{test_multiplicity_nonnegative()}} for matrices constrained to have non-negative eigenvalues.

In this package, matrices within the same sample are considered independently and identically distributed.
Matrices are stored in a flattened form as row-vectors according to \code{\link[=vech]{vech()}} - see \code{\link{fsm}} for details.
Samples may be provided as lists of matrices or in their flattened form so long as the column order matches that of \code{\link[=vech]{vech()}}.

This package includes a vignette demonstrating an application to anisotropy of magnetic susceptibility data.
For example applications of all the hypothesis tests in this package, please see the reproducibility document associated with \insertCite{hingee2026no}{TFORGE}.
}
\section{Acknowledgements}{
Colleagues Andrew T. A. Wood and Janice Scealy played crucial roles in developing the statistical concepts and theory.
This package was written on Ngunnawal and Ngambri Country.

The package includes \code{scel.R} for empirical likelihood by  \insertCite{owen:2013;textual}{TFORGE}, which is used to estimate optimal weights for weighted bootstrapping of samples of constrained matrices.
The \code{scel.R} file was released in 2014-2015 under the under BSD-3-Clause with
copyright by Board of Trustees, Leland Stanford Junior University
}

\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kasselhingee/TFORGE}
}

}
\author{
\strong{Maintainer}: Kassel Liam Hingee \email{kassel.hingee@anu.edu.au} (\href{https://orcid.org/0000-0001-9894-2407}{ORCID})

Other contributors:
\itemize{
  \item Art B. Owen (./R/scel.R only) [copyright holder]
  \item Board of Trustees Leland Stanford Junior University (./R/scel.R only) [copyright holder]
}

}
