% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcmc.R
\name{continue_pmcmc}
\alias{continue_pmcmc}
\alias{continue_pmcmc,SimInf_pmcmc-method}
\title{Run more iterations of PMCMC}
\usage{
continue_pmcmc(
  object,
  obs_process,
  n_iterations,
  post_proposal = NULL,
  init_model = NULL,
  post_particle = NULL,
  verbose = getOption("verbose", FALSE)
)

\S4method{continue_pmcmc}{SimInf_pmcmc}(
  object,
  obs_process,
  n_iterations,
  post_proposal = NULL,
  init_model = NULL,
  post_particle = NULL,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{object}{The \code{SimInf_pmcmc} object to continue from.}

\item{obs_process}{Specification of the stochastic observation
process. The \code{obs_process} can be specified as a
\code{formula} if the model contains only one node and there
is only one data point for each \code{time} in \code{data}.
The left hand side of the formula must match a column name in
the \code{data} data.frame and the right hand side of the
formula is a character specifying the distribution of the
observation process, for example, \code{Iobs ~ poisson(I)}.
The following distributions are supported: \code{x ~
binomial(size, prob)}, \code{x ~ poisson(rate)} and \code{x ~
uniform(min, max)}. The observation process can also be a
function to evaluate the probability density of the
observations given the simulated states. The first argument
passed to the \code{obs_process} function is the result from a
run of the model and it contains one trajectory with simulated
data for a time-point, where the trajectory contains
\code{n_particles} replicates, see
\code{\link{trajectory,SimInf_model-method}}. The second
argument to the \code{obs_process} function is a
\code{data.frame} containing the rows for the specific
time-point that the function is called for. Note that the
function must return the log of the density.}

\item{n_iterations}{An integer specifying the number of iterations
to run the PMCMC.}

\item{post_proposal}{An optional function that, if
non-\code{NULL}, is applied on the model after the proposal
has been set for the model, but before running the particle
filter. The function must accept one argument of type
\code{SimInf_model} with the current model of the fitting
process. This function can be useful to update, for example,
\code{ldata} of the model before running a trajectory with
proposed parameters. The function must return the model object
which is then used in the particle filter.}

\item{init_model}{An optional function that, if non-NULL, is
applied in the particle filter before running each
proposal. The function must accept one argument of type
\code{SimInf_model} with the current model of the fitting
process. This function can be useful to specify the initial
state of \code{u0} or \code{v0} of the model before running a
trajectory with proposed parameters.}

\item{post_particle}{An optional function that, if non-NULL, is
applied after each completed particle. The function must
accept three arguments: 1) an object of \code{SimInf_pmcmc}
with the current state of the fitting process, 2) an object
\code{SimInf_pfilter} with the last particle and one filtered
trajectory attached, and 3) an integer with the iteration in
the fitting process. This function can be useful to, for
example, monitor, save and inspect intermediate results. Note
that the second \code{SimInf_pfilter} argument, is non-NULL
only for the first particle in the chain, and for accepted
particles.}

\item{verbose}{prints diagnostic messages when \code{TRUE}. The
default is to retrieve the global option \code{verbose} and
use \code{FALSE} if it is not set. When \code{verbose=TRUE},
information is printed every 100 iterations. For pmcmc, it is
possible to get information every nth information by
specifying \code{verbose=n}, for example, \code{verbose=1} or
\code{verbose=10}.}
}
\description{
Run more iterations of PMCMC
}
