% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmd.R
\name{run_fmd_example}
\alias{run_fmd_example}
\title{Spatio-temporal analysis of the 2001 FMD outbreak (illustrative example)}
\usage{
run_fmd_example()
}
\value{
An object of class \code{"test"} returned by
\code{\link{dHS.test}}.
}
\description{
This function tests first-order separability for
the foot-and-mouth disease (FMD) outbreak data observed at the North Cumbria
study region provided by the \pkg{stpp} package.
}
\details{
The example includes kernel-based estimates of the spatio-temporal intensity and related separability
diagnostics on a regular spatio-temporal grid for fmd data as well as the dHSIC test.

The datasets \code{fmd} and \code{northcumbria} are loaded from the
\pkg{stpp} package and are used purely for illustration.
They do not contain confidential information and have no scientific value.
}
\examples{
\donttest{
if (requireNamespace("stpp", quietly = TRUE) ) {

  library(stpp)

  # Load data
  data("fmd", "northcumbria", package = "stpp")

  # Define spatial and temporal region
  s.region <- northcumbria / 1000
  t.region <- c(0, 200)

  # Create a spatio-temporal point pattern
  X <- as.3dpoints(
    fmd[, 1] / 1000,
    fmd[, 2] / 1000,
    fmd[, 3]
  )

  # Define observation window
  ObsW <- spatstat.geom::owin(
    poly = list(
      x = s.region[, 1],
      y = s.region[, 2]
    )
  )

  # Run Hilbert-Schmidt independence test
  oldpar <- par(no.readonly = TRUE)  # save current graphics settings
  on.exit(par(oldpar), add = TRUE)   # restore after example

  dHS.test(
    X,
    sim.procedure = "block_per",
    nblocks = 5L,
    nperm = 1999L,
    nsim = 199L,
    bandwidth = NULL
  )
 }
}

}
\references{
Diggle, P., Rowlingson, B. and Su, T. (2005).
Point process methodology for on-line spatio-temporal disease surveillance.
\emph{Environmetrics}, 16, 423--434.
}
\seealso{
\code{\link[stpp]{fmd}},
\code{\link[stpp]{northcumbria}},
\code{\link{S.based.functions}},
\code{\link{dHS.test}}
}
