% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_wcvp.R
\name{flag_wcvp}
\alias{flag_wcvp}
\title{Identify records outside natural ranges according to the World Checklist of Vascular Plants}
\usage{
flag_wcvp(
  data_dir,
  occ,
  species = "species",
  long = "decimalLongitude",
  lat = "decimalLatitude",
  origin = "native",
  buffer = 20,
  progress_bar = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data_dir}{(character) \strong{Required} directory path where the \code{WCVP}
data is saved}

\item{occ}{(data.frame or data.table) a data frame containing the occurrence
records to be flagged. Must contain columns for species, longitude, and
latitude.}

\item{species}{(character) the name of the column in \code{occ} that contains the
species scientific names. Default is \code{"species"}.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{origin}{(character) vector specifying which origin categories should
be considered as part of the species' range. Options are: \code{"native"},
\code{"introduced"}, \code{"extinct"}, \code{"location_doubtful"}, and \code{"all"}. For example,
if  \code{origin = "introduced"}, only regions where the species is considered
introduced will be used to validate records.  Default is \code{"native"}.}

\item{buffer}{(numeric) buffer distance (in kilometers) to be applied
around the region of distribution. Default is 20 km.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{verbose}{(logical) if \code{FALSE}, prints messages about the progress and
the number of species being checked. Default is \code{FALSE}.}
}
\value{
A \code{data.frame} that is the original \code{occ} data frame
augmented with a new column named \code{wcvp_flag}. This column is
logical (\code{TRUE}/\code{FALSE}) indicating whether the record falls
within the expected distribution (plus buffer) based on the \code{WCVP}
data. Records for species not found in the \code{WCVP} data will have
\code{NA} in the \code{wcvp_flag} column.
}
\description{
Flags (validates) occurrence records based on known distribution data
from the World Checklist of Vascular Plants (WCVP) data. This function checks
if an occurrence point for a given species falls within its documented
distribution, allowing for user-defined buffers around the region. Records
are flagged as valid (\code{TRUE}) if they fall inside the documented
distribution (plus optional buffer) for the species in the WCVP dataset.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Filter occurrences for Araucaria
occ <- occurrences[occurrences$species == "Araucaria angustifolia", ]
# Set folder where distributional datasets were saved
# Here, just a sample provided in the package
# You must run 'wcvp_here()' beforehand to download the necessary data files
dataset_dir <- system.file("extdata/datasets", package = "RuHere")

# Flag records using WCVP specialist information
occ_wcvp <- flag_wcvp(data_dir = dataset_dir, occ = occ)

}
