
<!-- README.md is generated from README.Rmd. Please edit that file -->

# RegEnRF

<!-- badges: start -->

[![R-CMD-check](https://github.com/umbe1987/regenrf/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/umbe1987/regenrf/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

`RegEnRF` is the implementation of the Regression-Enhanced Random
Forests algorithm as described in [Zhang et
al. (2019)](https://doi.org/10.48550/arXiv.1904.10416).

## Installation

You can install RegEnRF like so:

``` r
install.packages("RegEnRF")
```

or the development version like so:

``` r
devtools::install_github("umbe1987/regenrf")
```

## Example

This is an example showing how to perform Regression-Enhanced Random
Forests with `RegEnRF`. It demonstrates how `RegEnRF` can extrapolate
beyond the training domain, as opposed to `randomForest`.

``` r
library(RegEnRF)

set.seed(111)
data(co2)
x <- matrix(c(time(co2), cycle(co2)), ncol = 2)
y <- as.numeric(co2)
mod <- RegEnRF(x, y, lambda = 0.1)
#> Warning in rfout$mse/(var(y) * (n - 1)/n): Recycling array of length 1 in vector-array arithmetic is deprecated.
#>   Use c() or as.vector() instead.
freq <- frequency(co2)
startt <- tsp(co2)[2] + 1 / freq
xnew.t <- seq(startt, by = 1 / freq, length.out = freq * 3)
xnew <- matrix(c(xnew.t, cycle(tail(co2, freq * 3))), ncol = 2)
pred <- predict(mod, xnew)
pred.ts <- ts(pred, start = startt, frequency = freq)
plot(ts.union(co2, pred.ts), plot.type = "single", col = c("black", "red"))
```

<img src="man/figures/README-example-1.png" width="100%" />
