% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bct.R
\name{bct}
\alias{bct}
\alias{dbct}
\alias{pbct}
\alias{qbct}
\alias{rbct}
\title{Box–Cox t distribution (BCT)}
\usage{
dbct(x, mu = 5, sigma = 0.1, nu = 1, tau = 2, log = FALSE)

pbct(q, mu = 5, sigma = 0.1, nu = 1, tau = 2, lower.tail = TRUE, log.p = FALSE)

qbct(p, mu = 5, sigma = 0.1, nu = 1, tau = 2, lower.tail = TRUE, log.p = FALSE)

rbct(n, mu = 5, sigma = 0.1, nu = 1, tau = 2)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter, must be positive.}

\item{sigma}{scale parameter, must be positive.}

\item{nu}{skewness parameter (real).}

\item{tau}{degrees of freedom, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dbct} gives the density, \code{pbct} gives the distribution function, \code{qbct} gives the quantile function, and \code{rbct} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the Box–Cox t distribution.
}
\details{
This implementation of \code{dbct} and \code{pbct} allows for automatic differentiation with \code{RTMB} while the other functions are imported from \code{gamlss.dist} package.
See \code{gamlss.dist::\link[gamlss.dist]{BCT}} for more details.
}
\examples{
x <- rbct(1, mu = 10, sigma = 0.2, nu = 0.5, tau = 4)
d <- dbct(x, mu = 10, sigma = 0.2, nu = 0.5, tau = 4)
p <- pbct(x, mu = 10, sigma = 0.2, nu = 0.5, tau = 4)
q <- qbct(p, mu = 10, sigma = 0.2, nu = 0.5, tau = 4)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
