% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overfitSS.R
\name{overfitSS}
\alias{overfitSS}
\title{Testing search.shift overfit}
\usage{
overfitSS(RR,oveRR,node=NULL,state=NULL)
}
\arguments{
\item{RR}{an object produced by \code{\link{RRphylo}}.}

\item{oveRR}{an object produced by applying \code{\link{overfitRR}} on the
object provided to the function as \code{RR}.}

\item{node, state}{arguments passed to \code{\link{search.shift}}. Arguments
\code{node} and \code{state} can be specified at the same time.}
}
\value{
The function returns a 'RRphyloList' object containing:

\strong{$SSclade.list} a 'RRphyloList' including the results of each
  \code{search.shift - clade condition} performed within \code{overfitSS}.

\strong{$SSsparse.list} a 'RRphyloList' including the results of each
  \code{search.shift - sparse condition} performed within \code{overfitSS}.

\strong{$shift.results} a list including results for
  \code{\link{search.shift}} performed under \code{clade} and \code{sparse}
  conditions. If one or more \code{node}s are specified, the
  \code{$clade$single.clades} object contains the proportion of simulations
  producing significant and positive or significant and negative rate shifts
  for each single node, either compared to the rest of the tree
  (\code{$singles}) or to the rest of the tree after removing other shifting
  clades (\code{$no.others}). The object \code{$clade$all.clades.together}
  includes the same proportions obtained by testing all the specified clades
  as a whole (i.e. considering them as evolving under a single rate regime).
  For each node the proportion of tested trees (i.e. where the clade identity
  was preserved) is also indicated. If a \code{state} vector is supplied, the
  object \code{$sparse} contains the percentage of simulations producing
  significant p-value separated by shift sign (\code{$p.states}).

The output always has an attribute "Call" which returns an unevaluated call to the function.
}
\description{
Testing the robustness of \code{\link{search.shift}}
  (\cite{Castiglione et al. 2018}) results to sampling effects and
  phylogenetic uncertainty.
}
\examples{
\dontrun{
cc<- 2/parallel::detectCores()
# load the RRphylo example dataset including Ornithodirans tree and data
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
log(DataOrnithodirans$massdino)->massdino
DataOrnithodirans$statedino->statedino

# peform RRphylo on Ornithodirans tree and data
RRphylo(tree=treedino,y=massdino,clus=cc)->dinoRates

# perform search.shift under both "clade" and "sparse" condition
search.shift(RR=dinoRates, status.type= "clade")->SSauto
search.shift(RR=dinoRates, status.type= "sparse", state=statedino)->SSstate

## overfitSS routine
# generate a list of subsampled and swapped phylogenies, setting as categories/node
# the state/node under testing
treedino.list<-resampleTree(dinoRates$tree,s = 0.25,categories=statedino,
                        node=rownames(SSauto$single.clades),swap.si = 0.1,swap.si2 = 0.1,nsim=10)

# test the robustness of search.shift
ofRRdino<-overfitRR(RR = dinoRates,y=massdino,phylo.list=treedino.list,clus=cc)
ofSS<-overfitSS(RR = dinoRates,oveRR = ofRRdino,state=statedino,node=rownames(SSauto$single.clades))

}
}
\references{
Castiglione, S., Tesone, G., Piccolo, M., Melchionna, M.,
  Mondanaro, A., Serio, C., Di Febbraro, M., & Raia, P. (2018). A new method
  for testing evolutionary rate variation and shifts in phenotypic evolution.
  \emph{Methods in Ecology and Evolution}, 9:
  974-983.doi:10.1111/2041-210X.12954
}
\seealso{
\href{../doc/overfit.html}{\code{overfitSS} vignette} ;
  \href{../doc/search.shift.html}{\code{search.shift} vignette} ;
  \href{../doc/Alternative-trees.html}{\code{Alternative-trees} vignette}
}
\author{
Silvia Castiglione, Carmela Serio, Giorgia Girardi, Pasquale Raia
}
