% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRphylogeography.R
\name{RRphylogeography}
\alias{RRphylogeography}
\title{Find species area of origin}
\usage{
RRphylogeography(spec1,spec2,pred,occs,aggr=NULL,time_col=NULL,weights=c(0.5,0.5),
kde_inversion=FALSE,resistance_map=NULL,th=0.5,clust=0.5,plot=FALSE,
mask_for_pred=NULL,standardize=TRUE,output.dir)
}
\arguments{
\item{spec1, spec2}{character. The names of the sister species whose area of
origin should be inferred.}

\item{pred}{a list of two \code{SpatRaster} objects containing the prediction
maps in logistic output generated through any Species Distribution Model
technique. List names must correspond to \code{spec1} and \code{spec2}.}

\item{occs}{a list of two \code{sf::data.frame} objects containing species
occurrence data only in binary format (exclusively ones for presence). List
names must correspond to \code{spec1} and \code{spec2}.}

\item{aggr}{positive integer. Aggregation factor expressed as number of cells
in each direction to be aggregated by averaging cell values (optional).}

\item{time_col}{character. Name of the \code{occs} column containing the time
intervals associated to each species occurrence (optional).}

\item{weights}{weights to account for the arithmetic (first value) and
geometric (second value) means at calculating averaged suitability and
estimate kernel density (see details).}

\item{kde_inversion}{logical. If \code{TRUE} and \code{time_col} is provided,
kernel density is estimated by inverting the weights associated to the
occurrences of the oldest species.}

\item{resistance_map}{an optional \code{SpatRaster} object representing a
conductance matrix that numerically quantifies the resistance to move across
a surface (0 indicating maximum resistance, 1 indicating minimum
resistance).}

\item{th}{numeric. The threshold value to define most suitable cells of the
species pair as predicted via SDMs.}

\item{clust}{numeric. The proportion of the proportion of clusters to be used
in parallel computing. Default is 0.5. If \code{NULL}, parallel computing is
disabled.}

\item{plot}{logical. If \code{TRUE}, the area of the origin (RPO) maps with
and without the kernel estimation factors are plotted.}

\item{mask_for_pred}{a \code{SpatRaster} object representing the geographical
extent of the study area. This is used to crop the prediction maps define
the area of interest for the analysis (optional).}

\item{standardize}{logical. If \code{TRUE}, the Relative Probability (RPO)
values are standardized between 0 and 1.}

\item{output.dir}{character. The file path wherein \code{RRphylogeography}
creates a new folder to store the outputs. This new folder is renamed by
concatenating the names of the species pair.}
}
\value{
A list of \code{SpatRaster} objects which includes the area of the
 origin (RPO) and both relative probability (RPO) maps for the species pair
 calculated for each layer in the prediction maps.
}
\description{
The function integrates phylogenetic and geographical data (i.e.,
 habitat suitability maps), along with tools to model species' movements
 across landscapes. This integration allows for inference of the most
 probable area of origin (i.e. speciation) or regions of historical contact
 across time and space between a pair of target species.
}
\details{
\code{RRphylogeography} identifies the most suitable cells for both
 target species by relying on the \code{th} value. This threshold represents
 a numeric quantile so that any habitat suitability value greater than 0 that
 exceeds the value is considered to belong to the most suitable cells for the
 species. Conversely, the cells having habitat suitability values lower than
 \code{th} are excluded from distance calculation. When averaging the habitat
 suitabilities and kernel densities of target species both the arithmetic
 mean and the geometric mean are computed. The final combined surfaces are
 defined as a weighted average of the two means, with weights summing to 1,
 according to the formula: weights [1]\*arithmetic mean +
 weights[2]\*geometric mean
}
\examples{
\dontrun{

library(RRgeo)
library(terra)
library(sf)

newwd<-tempdir()
# newwd<-"YOUR_DIRECTORY"

rast(system.file("exdata/U.arctos_suitability.tif", package="RRgeo"))->map1
rast(system.file("exdata/U.maritimus_suitability.tif", package="RRgeo"))->map2
load(system.file("exdata/Ursus_occurrences.Rda", package="RRgeo"))
list(Ursus_arctos=map1,Ursus_maritimus=map2)->pred
list(Ursus_arctos=occs_arctos,Ursus_maritimus=occs_marit)->occs

RRphylogeography(spec1="Ursus_arctos",
                 spec2="Ursus_maritimus",
                 pred=pred,
                 occs=occs,
                 aggr=5,
                 time_col="TIME_factor",
                 weights=c(0.5,0.5),
                 kde_inversion=FALSE,
                 resistance_map=NULL,
                 clust=NULL,
                 plot=FALSE,
                 mask_for_pred=NULL,
                 th=0.7,
                 standardize=TRUE,
                 output.dir=newwd)
}
}
\references{
Mondanaro, A., Castiglione, S., Di Febbraro, M., Timmermann, A.,
 Girardi, G., Melchionna, M., Serio, C., Belfiore, A.M., & Raia, P. (2025).
 RRphylogeography: A new method to find the area of origin of species and the
 history of past contacts between species. \emph{Methods in Ecology and
 Evolution}, 16: 546-557. 10.1111/2041-210X.14478
}
\seealso{
\href{../doc/RRphylogeo.html}{\code{RRphylogeography} vignette}
}
\author{
Alessandro Mondanaro, Mirko Di Febbraro, Silvia Castiglione, Carmela
 Serio, Marina Melchionna, Pasquale Raia
}
