% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att.hierarchy.R
\name{att.hierarchy}
\alias{att.hierarchy}
\title{Iterative Attribute Hierarchy Exploration Methods for Cognitive Diagnosis Models}
\usage{
att.hierarchy(
  Y,
  Q,
  model = "GDINA",
  mono.constraint = FALSE,
  maxitr = 20,
  eps = 1e-07,
  alpha.level = 0.01,
  verbose = TRUE
)
}
\arguments{
\item{Y}{A required \eqn{N} × \eqn{I} matrix or \code{data.frame} consisting of the responses of 
\code{N} individuals to \eqn{I} items. Missing values need to be coded as \code{NA}.}

\item{Q}{A required binary \eqn{I} × \eqn{K} matrix containing the attributes not required or required 
master the items. The \code{i}th row of the matrix is a binary indicator vector indicating which
attributes are not required (coded by 0) and which attributes are required (coded by 1) to master
item \eqn{i}.}

\item{model}{Type of model to be fitted; can be \code{"GDINA"}, \code{"LCDM"}, \code{"DINA"}, \code{"DINO"},
\code{"ACDM"}, \code{"LLM"}, or \code{"rRUM"}. Default = \code{"GDINA"}.}

\item{mono.constraint}{Logical indicating whether monotonicity constraints should be fulfilled in estimation.
Default = \code{FALSE}.}

\item{maxitr}{Number of max iterations. Default = \code{20}.}

\item{eps}{Cut-off points of the minimum vallue of structural parameters.}

\item{alpha.level}{alpha level for the z-statistic test under Bonferroni correction. Default = \code{0.01}.}

\item{verbose}{Logical indicating to print iterative information or not. Default is \code{TRUE}}
}
\value{
An object of class \code{att.hierarchy} containing the following components:
\describe{
  \item{\code{statistic}}{A 4-column \code{matrix} for each structural parameter 
                          that is significantly larger than 0: the parameter estimate, its 
                          standard error (SE), the corresponding z-statistic, and the p-values after 
                          Bonferroni correction.}
  \item{\code{noSig}}{A \code{logical} scalar: \code{TRUE} if, during iteration, all structural 
                      parameters are not greater than 0; otherwise \code{FALSE}.}
  \item{\code{isNonverge}}{A \code{logical} scalar: \code{TRUE} if convergence was achieved 
              within \code{maxitr} iterations; \code{FALSE} if the algorithm did not converged.}
  \item{\code{pattern}}{The attribute mastery pattern matrix that contains every possible attribute 
                        mastery pattern.}
  \item{\code{arguments}}{A list that stores all input arguments supplied by the user.}
}
}
\description{
This function implements an exploratory method for attribute hierarchy structure (Zhang et al., 2025).
The procedure is iterative: in each step any structural parameter that is
\itemize{
  \item less than or equal to the pre-specified threshold \code{eps}, or
  \item not greater than 0 (tested by z-statistic under Bonferroni correction and standard erros are from XPD information matrix)
}
is fixed to zero and the remaining parameters are re-estimated.
Upon convergence, all structural parameters are both greater than \code{eps}
and significantly larger than 0. The attribute hierarchy is then inferred
from the set of parameters that remain significantly positive.
}
\references{
Zhang, X., Jiang, Y., Xin, T., & Liu, Y. (2025). Iterative Attribute Hierarchy Exploration Methods for Cognitive Diagnosis Models. Journal of Educational and Behavioral Statistics, 50(4), 682-713. https://doi.org/10.3102/10769986241268906
}
\author{
Haijiang Qin <Haijiang133@outlook.com>
}
