% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{verify_cleanup_app}
\alias{verify_cleanup_app}
\title{Interactive app for verifying auto cleanup.}
\usage{
verify_cleanup_app(data = data, LogFile = NULL)
}
\arguments{
\item{data}{A data table object.}

\item{LogFile}{A character string indicating the name (and location) of the
log file.}
}
\value{
Log file
}
\description{
\code{verify_cleanup_app} plots the data points changed during the
previously completed auto cleanup and allows the user to verify the cleanup
for specific events.  The app saves the selection to the RDS file, which can
then be used to apply the changes to the data set.
}
\examples{
if (interactive()) {

# Load example data
data("Pupilex3")

# Ensure the log file exists by running cleanup
# Writing log file to temporary folder for the example
dat <- clean_blink(Pupilex3, BlinkPadding = c(100, 100), Delta = 5,
                   MaxValueRun = 5, NAsAroundRun = c(2,2),
                   LogFile = paste0(tempdir(),"/BlinkCleanupLog.rds"))

# Read log file from temporary folder
verify_cleanup_app(dat, LogFile = paste0(tempdir(),"/BlinkCleanupLog.rds"))
}

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Cleanup", package="PupilPre")

}
