% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpsi.R
\name{plot.bpsi}
\alias{plot.bpsi}
\title{Plots for the \code{bpsi} object}
\usage{
\method{plot}{bpsi}(x, ..., category = "BPSI")
}
\arguments{
\item{x}{An object of class \code{bpsi}.}

\item{...}{currently not used}

\item{category}{A string indicating which plot to build. There are currently two
types of visualizations. Set "Ranks" for bar plots along each trait and "BPSI" (default) for circular bar plots multitrait.}
}
\description{
Build plots using the outputs stored in the \code{bpsi} object.
}
\examples{
\donttest{



mod = bayes_met(data = soy_pat,
                gen = "gen",
                loc = "env",
                repl = NULL,
                trait = "PH",
                reg = NULL,
                year = NULL,
                res.het = TRUE,
                iter = 2000, cores = 2, chain = 4)


mod2 = bayes_met(data = soy_pat,
                 gen = "gen",
                 loc = "env",
                 repl = NULL,
                 trait = "GY",
                 reg = NULL,
                 year = NULL,
                 res.het = TRUE,
                 iter = 2000, cores = 2, chain = 4)

mod3 = bayes_met(data = soy_pat,
                 gen = "gen",
                 loc = "env",
                 repl =  NULL,
                 trait = "NDM",
                 reg = NULL,
                 year = NULL,
                 res.het = TRUE,
                 iter = 2000, cores = 2, chain = 4)



models=list(mod,mod2,mod3)
names(models) <- c("PH","GY","NDM")
increase = c(FALSE,TRUE,FALSE)
names(increase) <- names(models)

probs = list()
for (i in names(models)) {
  outs <- extr_outs(model = models[[i]],
                    probs = c(0.05, 0.95),
                    verbose = TRUE)
  probs[[i]] <- prob_sup(
    extr = outs,
    int = .2,
    increase = increase[[i]],
    save.df = FALSE,
    verbose = TRUE
  )

}

index = bpsi(
  problist = probs,
  increase = increase,
  int = 0.1,
  lambda = c(1, 2, 1),
  save.df = FALSE
)

plot(index, category = "BPSI")
plot(index, category = "Ranks")
}
}
\references{
Chagas, J. T. B., Dias, K. O. das G., Quintão Carneiro, V., de Oliveira, L. M. C., Nunes, N. X., Júnior, J. D. P., Carneiro, P. C. S., & Carneiro, J. E. de S. (2025).
Bayesian probabilistic selection index in the selection of common bean families.
\emph{Crop Science}, 65(3).\doi{https://doi.org/10.1002/CSC2.70072}
}
\seealso{
\link{bpsi}
}
\author{
José Tiago Barroso Chagas
}
