% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_RatiosPG}
\alias{plot_RatiosPG}
\title{Plot ratios of labeled data (e.g. SILAC) from proteinGroups.txt}
\usage{
plot_RatiosPG(df_ratios, d_range, main_title, main_col, legend_title)
}
\arguments{
\item{df_ratios}{A data.frame with columns 'x', 'y', 'col', 'ltype'}

\item{d_range}{X-axis range of plot}

\item{main_title}{Plot title}

\item{main_col}{Color of title}

\item{legend_title}{Legend text}
}
\value{
GGplot object
}
\description{
The 'x' values are expected to be log2() transformed already.
}
\examples{

 x1 = seq(-3, 3, by = 0.1)
 y1 = dnorm(x1)
 x2 = seq(-5, 1, by = 0.1)
 y2 = dnorm(x2, mean = -1)
 data = data.frame( x = c(x1,x2),
                    y = c(y1,y2),
                    col = c(rep("ok", length(x1)), rep("shifted", length(x2))),
                    ltype = c(rep("solid", length(x1)), rep("dotted", length(x2))))
 plot_RatiosPG(data, range(data$x), "Ratio plot", "red", "group")

}
