% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_and_diagnosis.R
\name{summarize_ptsd}
\alias{summarize_ptsd}
\title{Summarize PTSD scores and diagnoses}
\usage{
summarize_ptsd(data)
}
\arguments{
\item{data}{A dataframe containing at minimum:

\itemize{
  \item A 'total' column with PCL-5 total scores (from calculate_ptsd_total)
  \item A 'PTSD_Diagnosis' column with TRUE/FALSE values (from
    determine_ptsd_diagnosis)
}}
}
\value{
A dataframe with one row containing:

\itemize{
  \item mean_total: Mean PCL-5 total score
  \item sd_total: Standard deviation of PCL-5 total scores
  \item n_diagnosed: Number of positive PTSD diagnoses
}
}
\description{
Creates a summary of PCL-5 total scores and PTSD diagnoses, including mean
total score, standard deviation, and number of positive diagnoses.
}
\details{
This function calculates key summary statistics for PCL-5 data:

\itemize{
\item Mean total score (severity indicator)
\item Standard deviation of total scores (variability in severity)
\item Count of positive PTSD diagnoses (prevalence in the sample)
}
}
\examples{
# Create sample data
sample_data <- data.frame(
  total = sample(0:80, 100, replace = TRUE),
  PTSD_Diagnosis = sample(c(TRUE, FALSE), 100, replace = TRUE)
)

# Generate summary statistics
summary_stats <- summarize_ptsd(sample_data)
print(summary_stats)

}
