% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U03-weights.R
\name{trim_weights_symmetric}
\alias{trim_weights_symmetric}
\title{Symmetric Propensity Score Trimming (Crump Extension)}
\usage{
trim_weights_symmetric(ps_result, data, treatment_var, delta = NULL)
}
\arguments{
\item{ps_result}{A list returned by \code{estimate_ps()}.}

\item{data}{A data.frame containing the treatment variable.}

\item{treatment_var}{A character string specifying the name of the treatment
variable in \code{data}.}

\item{delta}{Numeric trimming threshold in (0, 1/J] where J is the number
of treatment levels. Default is NULL, which uses recommended values:
0.1 for binary treatment, 0.067 for 3 groups, 1/(2*J) for J >= 4.}
}
\value{
A logical vector of length n, where TRUE indicates the observation
  should be kept and FALSE indicates it should be trimmed.
}
\description{
Performs symmetric trimming based on minimum propensity score across all
treatment groups. Implements the Crump extension to multiple treatments as
described in Yoshida et al. (2019).
}
\details{
The symmetric trimming rule retains observation i if:
\deqn{\min_j\{e_{ji}\} \geq \delta}

For binary treatment (J=2), this reduces to: \eqn{e(X) \in [\delta, 1-\delta]}.
}
\references{
Yoshida, K., et al. (2019). Multinomial extension of propensity score trimming
methods: A simulation study. \emph{American Journal of Epidemiology}, 188(3),
609-616.
}
\keyword{internal}
