% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.PPtreeExtclass.R
\name{print.PPtreeExtclass}
\alias{print.PPtreeExtclass}
\title{Print Method for PPtreeExtclass Objects}
\usage{
\method{print}{PPtreeExtclass}(x, coef.print = FALSE, cutoff.print = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{"PPtreeExtclass"} from 
\code{\link{PPtreeExtclass}} or \code{\link{PPtreeExt_split}}.}

\item{coef.print}{Logical indicating whether to print the projection coefficients 
for each split node. Default is \code{FALSE}.}

\item{cutoff.print}{Logical indicating whether to print the cutoff values for 
each split node. Default is \code{FALSE}.}

\item{verbose}{Logical indicating whether to print the tree structure and error 
rate. If \code{FALSE}, the function returns the tree structure invisibly without 
printing. Default is \code{TRUE}.}

\item{...}{Additional arguments (currently not used).}
}
\value{
The object x, invisibly
}
\description{
Prints a summary of a fitted projection pursuit classification tree, including 
the tree structure, optionally the projection coefficients and cutoff values, 
and the training error rate.
}
\details{
The function traverses the tree structure stored in \code{x$Tree.Struct} and 
creates a hierarchical text representation. When \code{coef.print = TRUE}, 
the projection coefficients (linear combinations of features) used at each 
split are displayed. When \code{cutoff.print = TRUE}, the threshold values 
used to determine left/right splits are shown.

The training error rate is computed by applying the fitted tree to the 
original training data.
}
\seealso{
\code{\link{PPtreeExtclass}}, \code{\link{PPtreeExt_split}}, 
  \code{\link{predict.PPtreeExtclass}}
}
