% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.and.evaluate.R
\name{fit.and.evaluate}
\alias{fit.and.evaluate}
\title{Fits the QC data to distributions and returns the KS test result and BIC score}
\usage{
fit.and.evaluate(
  quality.scores,
  distributions = c("weibull", "norm", "gamma", "exp", "lnorm", "cauchy", "logis"),
  trim.factor = 0.05
)
}
\arguments{
\item{quality.scores}{The accumulated QC scores, the output of accumulate.zscores}

\item{distributions}{A vector of distributions to fit and test}

\item{trim.factor}{The fraction of extremes on each end to trim before fitting}
}
\value{
A dataframe of the results with the following columns
\describe{
\item{distribution}{Name of the fitted distribution}
\item{KS.rejected}{Whether the Kolmogorov-Smirnov test rejects the fit; see \code{fitdistrplus::gofstat} - kstest}
\item{BIC.value}{Bayesian Information Criterion}
}
}
\description{
This function takes the accumulated QC scores, a vector of distributions
and a trimming factor. It then returns the results for each distribution
in a dataframe. This function supports the following distributions:
\itemize{
\item 'weibull'
\item 'norm'
\item 'gamma'
\item 'exp'
\item 'lnorm'
\item 'cauchy'
\item 'logis'
}
}
