% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getSccsTable}
\alias{getSccsTable}
\title{Extract the SCCS table specified}
\usage{
getSccsTable(
  connectionHandler,
  schema,
  table = c("attrition", "time_trend", "event_dep_observation", "age_spanning",
    "calendar_time_spanning", "spline")[1],
  sccsTablePrefix = "sccs_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  indicationIds = NULL,
  outcomeIds = NULL,
  analysisIds = NULL,
  databaseIds = NULL,
  exposureOutcomeIds = NULL,
  covariateIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{table}{The result table to extract}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{indicationIds}{The indications that the target was nested to}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{analysisIds}{the analysis IDs to restrict to}

\item{databaseIds}{the database IDs to restrict to}

\item{exposureOutcomeIds}{the exposureOutcomeIds to restrict to}

\item{covariateIds}{the covariateIds to restrict to}
}
\value{
Returns a data.frame with the cohort method requested table
}
\description{
This function extracts the specific cohort method table.
}
\details{
Specify the connectionHandler, the schema and optionally the target/outcome/analysis/database IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsTable <- getSccsTable(
  connectionHandler = connectionHandler, 
  schema = 'main',
  table = 'attrition'
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
