% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obic.R
\name{obic_field}
\alias{obic_field}
\title{Calculate the Open Bodem Index score for one field}
\usage{
obic_field(
  B_SOILTYPE_AGR,
  B_GWL_CLASS,
  B_SC_WENR,
  B_HELP_WENR,
  B_AER_CBS,
  B_GWL_GLG,
  B_GWL_GHG,
  B_GWL_ZCRIT,
  B_LU_BRP,
  A_SOM_LOI,
  A_SAND_MI,
  A_SILT_MI,
  A_CLAY_MI,
  A_PH_CC,
  A_N_RT,
  A_CN_FR,
  A_S_RT,
  A_N_PMN,
  A_P_AL,
  A_P_CC,
  A_P_WA,
  A_CEC_CO,
  A_CA_CO_PO,
  A_MG_CO_PO,
  A_K_CO_PO,
  A_K_CC,
  A_MG_CC,
  A_MN_CC,
  A_ZN_CC,
  A_CU_CC,
  A_C_BCS = NA,
  A_CC_BCS = NA,
  A_GS_BCS = NA,
  A_P_BCS = NA,
  A_RD_BCS = NA,
  A_EW_BCS = NA,
  A_SS_BCS = NA,
  A_RT_BCS = NA,
  A_SC_BCS = NA,
  B_DRAIN = NA,
  B_FERT_NORM_FR = 1,
  M_COMPOST = NA_real_,
  M_GREEN = NA,
  M_NONBARE = NA,
  M_EARLYCROP = NA,
  M_SLEEPHOSE = NA,
  M_DRAIN = NA,
  M_DITCH = NA,
  M_UNDERSEED = NA,
  M_LIME = NA,
  M_NONINVTILL = NA,
  M_SSPM = NA,
  M_SOLIDMANURE = NA,
  M_STRAWRESIDUE = NA,
  M_MECHWEEDS = NA,
  M_PESTICIDES_DST = NA,
  ID = 1,
  output = "all",
  useClassicOBI = TRUE,
  B_AREA_DROUGHT = NA
)
}
\arguments{
\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{B_GWL_CLASS}{(character) The groundwater table class}

\item{B_SC_WENR}{(character) The risk for subsoil compaction as derived from risk assessment study of Van den Akker (2006).}

\item{B_HELP_WENR}{(character) The soil type abbreviation, derived from 1:50.000 soil map}

\item{B_AER_CBS}{(character) The agricultural economic region in the Netherlands (CBS, 2016)}

\item{B_GWL_GLG}{(numeric) The lowest groundwater level averaged over the most dry periods in 8 years in cm below ground level}

\item{B_GWL_GHG}{(numeric) The highest groundwater level averaged over the most wet periods in 8 years in cm below ground level}

\item{B_GWL_ZCRIT}{(numeric) The distance between ground level and groundwater level at which the groundwater can supply the soil surface with 2mm water per day (in cm)}

\item{B_LU_BRP}{(numeric) a series with crop codes given the crop rotation plan (source: the BRP)}

\item{A_SOM_LOI}{(numeric) The percentage organic matter in the soil (\%)}

\item{A_SAND_MI}{(numeric) The sand content of the soil (\%)}

\item{A_SILT_MI}{(numeric) The silt content of the soil (\%)}

\item{A_CLAY_MI}{(numeric) The clay content of the soil (\%)}

\item{A_PH_CC}{(numeric) The acidity of the soil, measured in 0.01M CaCl2 (-)}

\item{A_N_RT}{(numeric) The organic nitrogen content of the soil in mg N / kg}

\item{A_CN_FR}{(numeric) The carbon to nitrogen ratio (-)}

\item{A_S_RT}{(numeric) The total Sulfur content of the soil (in mg S per kg)}

\item{A_N_PMN}{(numeric) The potentially mineralizable N pool (mg N / kg soil)}

\item{A_P_AL}{(numeric) The P-AL content of the soil}

\item{A_P_CC}{(numeric) The plant available P content, extracted with 0.01M CaCl2 (mg / kg)}

\item{A_P_WA}{(numeric) The P-content of the soil extracted with water (mg P2O5 / 100 ml soil)}

\item{A_CEC_CO}{(numeric) The cation exchange capacity of the soil (mmol+ / kg), analyzed via Cobalt-hexamine extraction}

\item{A_CA_CO_PO}{(numeric) The The occupation of the CEC with Ca (\%)}

\item{A_MG_CO_PO}{(numeric) The The occupation of the CEC with Mg (\%)}

\item{A_K_CO_PO}{(numeric) The occupation of the CEC with K (\%)}

\item{A_K_CC}{(numeric) The plant available K content, extracted with 0.01M CaCl2 (mg / kg)}

\item{A_MG_CC}{(numeric) The plant available Mg content, extracted with 0.01M CaCl2 (ug / kg)}

\item{A_MN_CC}{(numeric) The plant available Mn content, extracted with 0.01M CaCl2 (ug / kg)}

\item{A_ZN_CC}{(numeric) The plant available Zn content, extracted with 0.01M CaCl2 (ug / kg)}

\item{A_CU_CC}{(numeric) The plant available Cu content, extracted with 0.01M CaCl2 (ug / kg)}

\item{A_C_BCS}{(numeric) The presence of visible cracks in the top layer (optional, score 0-1-2)}

\item{A_CC_BCS}{(integer) The crop cover on the surface (optional, score 0-1-2)}

\item{A_GS_BCS}{(numeric) The presence of waterlogged conditions, gley spots (optional, score 0-1-2)}

\item{A_P_BCS}{(numeric) The presence / occurrence of water puddles on the land, ponding (optional, score 0-1-2)}

\item{A_RD_BCS}{(integer) The rooting depth (optional, score 0-1-2)}

\item{A_EW_BCS}{(numeric) The presence of earth worms (optional, score 0-1-2)}

\item{A_SS_BCS}{(integer) The soil structure (optional, score 0-1-2)}

\item{A_RT_BCS}{(numeric) The presence of visible tracks / rutting or trampling on the land (optional, score 0-1-2)}

\item{A_SC_BCS}{(numeric) The presence of compaction of subsoil (optional, score 0-1-2)}

\item{B_DRAIN}{(boolean) Are drains installed to drain the field (options: yes or no)}

\item{B_FERT_NORM_FR}{(numeric) The fraction of the application norm utilized}

\item{M_COMPOST}{(numeric) The frequency that compost is applied (optional, every x years)}

\item{M_GREEN}{(boolean) A soil measure. Are catch crops sown after main crop (optional, option: yes or no)}

\item{M_NONBARE}{(boolean) A soil measure. Is parcel for 80 percent of the year cultivated and 'green' (optional, option: yes or no)}

\item{M_EARLYCROP}{(boolean) A soil measure. Use of early crop varieties to avoid late harvesting (optional, option: yes or no)}

\item{M_SLEEPHOSE}{(boolean) A soil measure. Is sleephose used for slurry application (optional, option: yes or no)}

\item{M_DRAIN}{(boolean) A soil measure. Are under water drains installed in peaty soils (optional, option: yes or no)}

\item{M_DITCH}{(boolean) A soil measure. Are ditched maintained carefully and slib applied on the land (optional, option: yes or no)}

\item{M_UNDERSEED}{(boolean) A soil measure. Is grass used as second crop in between maize rows (optional, option: yes or no)}

\item{M_LIME}{(boolean) measure. Has field been limed in last three years (option: yes or no)}

\item{M_NONINVTILL}{(boolean) measure. Non inversion tillage (option: yes or no)}

\item{M_SSPM}{(boolean) measure. Soil Structure Protection Measures, such as fixed driving lines, low pressure tires, and light weighted machinery (option: yes or no)}

\item{M_SOLIDMANURE}{(boolean) measure. Use of solid manure (option: yes or no)}

\item{M_STRAWRESIDUE}{(boolean) measure. Application of straw residues (option: yes or no)}

\item{M_MECHWEEDS}{(boolean) measure. Use of mechanical weed protection (option: yes or no)}

\item{M_PESTICIDES_DST}{(boolean) measure. Use of DST for pesticides (option: yes or no)}

\item{ID}{(character) A field id}

\item{output}{(character) An optional argument to select output: obic_score, scores, indicators, recommendations, or all. (default = all)}

\item{useClassicOBI}{(boolean) Whether you want to only include agronomic
indicators and scores as intended by the OBI framework or whether you want
to include environmental indicators in your score aggregation, more akin to BLN 2.0.
Defaults to TRUE.}

\item{B_AREA_DROUGHT}{(boolean) is the field located in an area with high risks for water deficiencies (options: TRUE or FALSE)}
}
\value{
The output of the Open Bodem Index Calculator for a specific agricultural field. 
Depending on the output type, different output objects can be returned.
These include the estimated OBI scores (both total and aggregated subscores), the value of the underling indicators as well the possible recommendations to improve the soil quality.
The output is always a data.table.
}
\description{
This functions wraps the functions of the OBIC into one main function to calculate the score for Open Bodem Index (OBI) for a single field.
}
\details{
It is assumed that the crop series is a continuous series in decreasing order of years. So most recent year first, oldest year last.
}
\examples{

\dontrun{
obic_field( B_SOILTYPE_AGR = 'rivierklei',B_GWL_CLASS = "II",B_GWL_GLG = 75,B_GWL_GHG = 10,
B_GWL_ZCRIT = 50,B_SC_WENR = '2',B_HELP_WENR = "MOb72",B_AER_CBS = 'LG01',
B_LU_BRP = c( 1010, 1010,263,263, 263,265,265,265),A_SOM_LOI = 3.91,A_SAND_MI = 66.3,
A_SILT_MI = 22.8,A_CLAY_MI = 7.8,A_PH_CC = 5.4,A_N_RT = 1528.33,A_CN_FR = 13.02,
A_S_RT = 321.26,A_N_PMN = 63.3,A_P_AL = 50.2,A_P_CC = 2.9,A_P_WA = 50.5,
A_CEC_CO = 56.9,A_CA_CO_PO = 66.87,A_MG_CO_PO = 13.97,A_K_CO_PO = 3.06,
A_K_CC = 58.6,A_MG_CC = 77.53,A_MN_CC = 7586.61,A_ZN_CC = 726.2,A_CU_CC = 68.8,
A_C_BCS = 1,A_CC_BCS = 1,A_GS_BCS = 1,A_P_BCS = 1,A_RD_BCS = 1,A_EW_BCS = 1,
A_SS_BCS = 1,A_RT_BCS = 1,A_SC_BCS = 1,M_COMPOST = 0,M_GREEN = FALSE,M_NONBARE =FALSE,
M_EARLYCROP = FALSE,M_SLEEPHOSE = FALSE,M_DRAIN = FALSE,M_DITCH = FALSE,
M_UNDERSEED = FALSE,M_LIME = FALSE,M_MECHWEEDS = FALSE,M_NONINVTILL = FALSE,
M_PESTICIDES_DST = FALSE,M_SOLIDMANURE = FALSE,M_SSPM = FALSE,M_STRAWRESIDUE = FALSE,
B_AREA_DROUGHT = FALSE)
}
 
}
