if (!torch::torch_is_installed()) {
  testthat::skip("Torch backend (Lantern) not installed")
}

testthat::test_that("NNMoMoData returns correct class", {
  demo_obj <- demography::demogdata(
    data = matrix(runif(10*5), nrow = 10),
    pop = matrix(runif(10*5, 1000, 2000), nrow = 10),
    ages = 0:9,
    years = 2000:2004,
    type = "mortality",
    name = "male",
    label = "TestCountry"
  )

  nn_data <- NNMoMoData(demo_obj)
  expect_s3_class(nn_data, "NNMoMoData")
  expect_s3_class(nn_data, "data.frame")
})

testthat::test_that("NNMoMoData stops if input is not demogdata", {
  expect_error(NNMoMoData(c(1,2,3)))
})

testthat::test_that("NNMoMoData produces expected columns", {
  demo_obj <- demography::demogdata(
    data = matrix(runif(2*2), nrow = 2),
    pop = matrix(runif(2*2, 1000, 2000), nrow = 2),
    ages = 0:1,
    years = 2000:2001,
    type = "mortality",
    name = "male",
    label = "TestCountry"
  )

  nn_data <- NNMoMoData(demo_obj)
  expect_true(
    all(
      c(
        "country", "sex", "year",
        "rate_0", "rate_1",
        "pop_0", "pop_1"
      ) %in% colnames(nn_data)
    )
  )
})
