#' Print Method for NNMoMoData Objects
#'
#' Method for printing the output of \code{\link{NNMoMoData}}. Gives fundamental
#' infofmation about the object.
#'
#' @param x An object of class \code{NNMoMoData}.
#' @param ... Further arguments passed to or from other methods.
#'
#' @return Prints basic information about the \code{NNMoMoData} object to the
#' console.
#'
#' @export
print.NNMoMoData <- function(x, ...) {
  cat("NNMoMoData object:\n")
  cat("  Countries :", length(unique(x$country)), "\n")
  cat("  Years     :", paste0(min(x$year), "-", max(x$year)), "\n")
  cat("  Rows      :", nrow(x), "\n")
}
