% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_scaling.R
\name{validate_and_apply_nmar_scaling}
\alias{validate_and_apply_nmar_scaling}
\title{Validate and apply scaling for engines}
\usage{
validate_and_apply_nmar_scaling(
  standardize,
  has_aux,
  response_model_matrix_unscaled,
  aux_matrix_unscaled,
  mu_x_unscaled,
  weights = NULL,
  weight_mask = NULL
)
}
\arguments{
\item{standardize}{logical; apply standardization if TRUE.}

\item{has_aux}{logical; whether the engine uses auxiliary constraints.}

\item{response_model_matrix_unscaled}{response model matrix (with intercept).}

\item{aux_matrix_unscaled}{auxiliary matrix (no intercept) or an empty matrix.}

\item{mu_x_unscaled}{named auxiliary means on original scale, or NULL.}

\item{weights}{Optional numeric vector used for weighted scaling.}

\item{weight_mask}{Optional logical mask or nonnegative numeric multipliers
applied to \code{weights}.}
}
\value{
A list with components \code{nmar_scaling_recipe},
\code{response_model_matrix_scaled}, \code{auxiliary_matrix_scaled}, and \code{mu_x_scaled}.
}
\description{
Validate and apply scaling for engines
}
\keyword{internal}
