% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{has.method}
\alias{has.method}
\title{Determine whether a function can be applied to an S4 class/object}
\usage{
has.method(FUN, CLASS, false.if.error = FALSE, ...)
}
\arguments{
\item{FUN}{the function to test, can be specified as a string, or the actual function itself}

\item{CLASS}{a specific object or a class of objects specified by a string, e.g, "GRanges"}

\item{false.if.error}{logical, the default value is FALSE, in which case an error is returned
when FUN is not an S4 generic function. If this parameter is set to TRUE, 'FALSE' will
be returned with a warning instead of an error.}

\item{...}{additional arguments to showMethods(), e.g, 'where' to specify the environment}
}
\value{
returns logical (TRUE/FALSE), or if the function is not S4 will return an error,
although this could potentially be because the function's package has not been loaded.
}
\description{
Wrapper for 'showMethods', allows easy testing whether a function
(can be specified as a string, or the actual function itself (FUN)) can be
applied to a specific object or class of objects (CLASS)
}
\examples{
require(Matrix); require(methods)
has.method("t","dgeMatrix") # t() is the transpose method for a dgeMatrix object
has.method(t,"dgeMatrix") # also works without quotes for the method
m.example <- as(matrix(rnorm(100),ncol=5),"dgeMatrix")
has.method(t, m.example) # works with an instance of an object type too
has.method("band", m.example) # band is a function for a 'denseMatrix' but not 'dgeMatrix'
## not run # has.method("notAFunction","GRanges") # should return error
## not run # has.method("notAFunction","GRanges",TRUE) # should return FALSE and a warning
}
