% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_output.R
\name{format_metarvm_output}
\alias{format_metarvm_output}
\title{Format MetaRVM simulation output}
\usage{
format_metarvm_output(sim_output, config)
}
\arguments{
\item{sim_output}{data.table containing raw simulation output from \code{\link{meta_sim}}}

\item{config}{MetaRVMConfig object or config list containing parameters}
}
\value{
data.table with formatted output including calendar dates and demographics
}
\description{
This function formats raw MetaRVM simulation output by:
\enumerate{
\item Converting time steps to calendar dates
\item Adding demographic attributes from population mapping
\item Handling different disease states appropriately:
\itemize{
\item Regular states (S, E, I, etc.): Keep values at integer time points
\item New count states (n_ prefix): Sum pairs to get daily counts
}
}
}
\section{Note}{

This function is used for formatting the \code{\link{meta_sim}} output when \code{\link{MetaRVM}}
function is called.
}

