% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_package2.R
\name{path_package2}
\alias{path_package2}
\title{Construct a path to a location within an installed or development package}
\usage{
path_package2(
  target,
  package = NULL,
  nparents = 1,
  subdirs = c("extdata", paste("inst", "extdata", sep = .Platform$file.sep))
)
}
\arguments{
\item{target}{A regular expression describing the file of folder desired.}

\item{package}{Name of the package to in which to search. If \code{NULL}, search
in the working directory. Otherwise search in \code{system.file(package)}.}

\item{nparents}{integer indicate the number of parents of the working
directory in which to search; default = 1.}

\item{subdirs}{= \code{c('extdata',   paste('inst','extdata', sep=.Platform$file.sep))}}
}
\value{
a character vector with an attribute \code{searched} giving the full
paths of all directories searched for \code{target}.
}
\description{
\code{path_package2} returns a character vector of matches to \code{target}.
It differs from \code{\link[=system.file]{system.file()}} in that it supports searching for a \code{target}
file or folder possibly in \code{subdirs} of the working directory or in
\code{nparents} of its parents.
}
\details{
This works in a vignette searching for a \code{target} that could be in the
\code{vignettes} directory of its parent package or in the package directory
or in, e.g., one of \code{subdirs = c('extdata',  paste('inst', 'extdata',  sep=.Platform$file.sep))}.

Returns the full path to match(s) if found and a character vector of length
0 if no matches are found. The returned object also has a \code{searched}
attribute being a character vector of the directories searched.

This was inspired by a desire to share with others a vignette describing how
to create data objects from a file that could not itself be shared on CRAN.
This is not easy, because the working director available to code in a
vignette changes depending on how that code is run.

\code{path_package2} allows the user to store the \code{target} locally, e.g., in
\code{inst/extdata} but include it in \code{.gitignore} to prevent it from leaving the
local computer. The vignette then decides what to do after calling
\code{path_package2()} based on the length of the the object returned.
}
\examples{
# search for a file matching a regular expression
path_package2('^mpd.*xlsx$') 
# search only in the working directory
path_package2('^mpd.*xlsx$', nparents=0, subdirs=character(0)) 

}
\keyword{file}
