% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainingParams.R
\name{set_monitor}
\alias{set_monitor}
\alias{set_monitor.MLControl}
\alias{set_monitor.MLOptimization}
\alias{set_monitor.ModelSpecification}
\title{Training Parameters Monitoring Control}
\usage{
set_monitor(object, ...)

\method{set_monitor}{MLControl}(object, progress = TRUE, verbose = FALSE, ...)

\method{set_monitor}{MLOptimization}(object, progress = FALSE, verbose = FALSE, ...)

\method{set_monitor}{ModelSpecification}(object, which = c("all", "control", "optim"), ...)
}
\arguments{
\item{object}{resampling \link[=controls]{control},
tuning parameter \link[=set_optim]{optimization}, or model
\link[=ModelSpecification]{specification} object.}

\item{...}{arguments passed from the \code{ModelSpecification} method to the
others.}

\item{progress}{logical indicating whether to display iterative progress
during resampling or optimization.  In the case of resampling, a progress
bar will be displayed if a computing cluster is not registered or is
registered with the \pkg{doSNOW} package.}

\item{verbose}{numeric or logical value specifying the level of progress
detail to print, with 0 (\code{FALSE}) indicating none and 1 (\code{TRUE})
or higher indicating increasing amounts of detail.}

\item{which}{character string specifying the monitoring parameters to set as
\code{"all"}, \code{"control"}, or optimization (\code{"optim"}).}
}
\value{
Argument \code{object} updated with the supplied parameters.
}
\description{
Set parameters that control the monitoring of resample estimation of model
performance and of tuning parameter optimization.
}
\examples{
CVControl() \%>\% set_monitor(verbose = TRUE)

}
\seealso{
\code{\link{resample}}, \code{\link{set_optim}},
\code{\link{set_predict}}, \code{\link{set_strata}}
}
