% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{quote}
\alias{quote}
\alias{.}
\title{Quote Operator}
\usage{
.(expr)
}
\arguments{
\item{expr}{any syntactically valid \R expression.}
}
\value{
The quoted (unevaluated) expression.
}
\description{
Shorthand notation for the \code{\link[base:substitute]{quote}} function.
The quote operator simply returns its argument unevaluated and can be applied
to any \R expression.
}
\details{
Useful for calling \link[=models]{model functions} with quoted parameter
values defined in terms of one or more of the following variables.
\describe{
  \item{\code{nobs}}{number of observations in data to be \link{fit}.}
  \item{\code{nvars}}{number of predictor variables.}
  \item{\code{y}}{the response variable.}
}
}
\examples{
## Stepwise variable selection with BIC
glm_fit <- fit(sale_amount ~ ., ICHomes, GLMStepAICModel(k = .(log(nobs))))
varimp(glm_fit)

}
\seealso{
\code{\link[base:substitute]{quote}}
}
