% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R, R/metrics_factor.R,
%   R/metrics_numeric.R
\name{metrics}
\alias{metrics}
\alias{accuracy}
\alias{auc}
\alias{brier}
\alias{cindex}
\alias{cross_entropy}
\alias{f_score}
\alias{fnr}
\alias{fpr}
\alias{kappa2}
\alias{npv}
\alias{ppr}
\alias{ppv}
\alias{pr_auc}
\alias{precision}
\alias{recall}
\alias{roc_auc}
\alias{roc_index}
\alias{sensitivity}
\alias{specificity}
\alias{tnr}
\alias{tpr}
\alias{weighted_kappa2}
\alias{gini}
\alias{mae}
\alias{mse}
\alias{msle}
\alias{r2}
\alias{rmse}
\alias{rmsle}
\title{Performance Metrics}
\usage{
accuracy(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

auc(
  observed,
  predicted = NULL,
  weights = NULL,
  multiclass = c("pairs", "all"),
  metrics = c(MachineShop::tpr, MachineShop::fpr),
  stat = MachineShop::settings("stat.Curve"),
  ...
)

brier(observed, predicted = NULL, weights = NULL, ...)

cindex(observed, predicted = NULL, weights = NULL, ...)

cross_entropy(observed, predicted = NULL, weights = NULL, ...)

f_score(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  beta = 1,
  ...
)

fnr(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

fpr(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

kappa2(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

npv(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

ppr(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

ppv(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

pr_auc(
  observed,
  predicted = NULL,
  weights = NULL,
  multiclass = c("pairs", "all"),
  ...
)

precision(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

recall(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

roc_auc(
  observed,
  predicted = NULL,
  weights = NULL,
  multiclass = c("pairs", "all"),
  ...
)

roc_index(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  fun = function(sensitivity, specificity) (sensitivity + specificity)/2,
  ...
)

sensitivity(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

specificity(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

tnr(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

tpr(
  observed,
  predicted = NULL,
  weights = NULL,
  cutoff = MachineShop::settings("cutoff"),
  ...
)

weighted_kappa2(observed, predicted = NULL, weights = NULL, power = 1, ...)

gini(observed, predicted = NULL, weights = NULL, ...)

mae(observed, predicted = NULL, weights = NULL, ...)

mse(observed, predicted = NULL, weights = NULL, ...)

msle(observed, predicted = NULL, weights = NULL, ...)

r2(
  observed,
  predicted = NULL,
  weights = NULL,
  method = c("mse", "pearson", "spearman"),
  distr = character(),
  ...
)

rmse(observed, predicted = NULL, weights = NULL, ...)

rmsle(observed, predicted = NULL, weights = NULL, ...)
}
\arguments{
\item{observed}{\link[=response]{observed responses}; or
\link{confusion}, \link[=curves]{performance curve}, or \link{resample}
result containing observed and predicted responses.}

\item{predicted}{\link[=predict]{predicted responses} if not contained in
\code{observed}.}

\item{weights}{numeric vector of non-negative
\link[=case_weights]{case weights} for the observed responses [default:
equal weights].}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.  If \code{NULL}, then confusion matrix-based
metrics are computed on predicted class probabilities if given.}

\item{...}{arguments passed to or from other methods.}

\item{multiclass}{character string specifying the method for computing
generalized area under the performance curve for multiclass factor
responses.  Options are to average over areas for each pair of classes
(\code{"pairs"}) or for each class versus all others (\code{"all"}).}

\item{metrics}{vector of two metric functions or function names that define a
curve under which to calculate area [default: ROC metrics].}

\item{stat}{function or character string naming a function to compute a
summary statistic at each cutoff value of resampled metrics in performance
curves, or \code{NULL} for resample-specific metrics.}

\item{beta}{relative importance of recall to precision in the calculation of
\code{f_score} [default: F1 score].}

\item{fun}{function to calculate a desired sensitivity-specificity tradeoff.}

\item{power}{power to which positional distances of off-diagonals from the
main diagonal in confusion matrices are raised to calculate
\code{weighted_kappa2}.}

\item{method}{character string specifying whether to compute \code{r2} as
the coefficient of determination (\code{"mse"}) or as the square of
\code{"pearson"} or \code{"spearman"} correlation.}

\item{distr}{character string specifying a distribution with which to
estimate the observed survival mean in the total sum of square component of
\code{r2}.  Possible values are \code{"empirical"} for the Kaplan-Meier
estimator, \code{"exponential"}, \code{"extreme"}, \code{"gaussian"},
\code{"loggaussian"}, \code{"logistic"}, \code{"loglogistic"},
\code{"lognormal"}, \code{"rayleigh"}, \code{"t"}, or \code{"weibull"}.
Defaults to the distribution that was used in predicting mean survival
times.}
}
\description{
Compute measures of agreement between observed and predicted responses.
}
\references{
Hand, D. J., & Till, R. J. (2001). A simple generalisation of the area under
the ROC curve for multiple class classification problems. \emph{Machine
Learning}, \emph{45}, 171-186.
}
\seealso{
\code{\link{metricinfo}}, \code{\link{performance}}
}
