% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_data}
\alias{load_data}
\title{Load tabular data (xlsx, csv, or json)}
\usage{
load_data(data_path)
}
\arguments{
\item{data_path}{Character scalar; path to a \code{.xlsx}, \code{.csv}, or \code{.json} file.}
}
\value{
A base \code{data.frame} with the imported data.
}
\description{
Load tabular data (xlsx, csv, or json)
}
\examples{
tmp_csv <- tempfile(fileext = ".csv")
utils::write.csv(data.frame(a = 1:2, b = c("x", "y")), tmp_csv, row.names = FALSE)
load_data(tmp_csv)

tmp_json <- tempfile(fileext = ".json")
jsonlite::write_json(list(a = 1:2, b = c("x","y")), tmp_json, auto_unbox = TRUE)
load_data(tmp_json)

tmp_xlsx <- tempfile(fileext = ".xlsx")
openxlsx::write.xlsx(data.frame(a = 1:2, b = c("x","y")), tmp_xlsx)
load_data(tmp_xlsx)
}
