% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_CosmicRayRemoval.R
\name{apply_CosmicRayRemoval}
\alias{apply_CosmicRayRemoval}
\title{Cosmic-ray removal and spectrum smoothing for RLum.Data.Spectrum objects}
\usage{
apply_CosmicRayRemoval(
  object,
  method = "smooth",
  method.Pych.smoothing = 2,
  method.Pych.threshold_factor = 3,
  MARGIN = 2,
  verbose = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Spectrum} or \linkS4class{RLum.Analysis} (\strong{required}):
input object to be treated, which can be also provided as \link{list}. If an
\linkS4class{RLum.Analysis} object is provided, only its \linkS4class{RLum.Data.Spectrum}
objects are treated. Please note: this mixing of objects does not work for
a list of \code{RLum.Data} objects.}

\item{method}{\link{character} (\emph{with default}):
Defines method that is applied for cosmic ray removal. Allowed methods are
\code{smooth}, the default, (\link[stats:smooth]{stats::smooth}), \code{smooth.spline} (\link[stats:smooth.spline]{stats::smooth.spline}),
\code{smooth_RLum} (\link{smooth_RLum}) and \code{Pych}. See details for further information.}

\item{method.Pych.smoothing}{\link{integer} (\emph{with default}):
Smoothing parameter for cosmic ray removal according to Pych (2003).
The value defines how many neighbouring values in each frame are used for smoothing
(e.g., \code{2} means that the two previous and two following values are used).}

\item{method.Pych.threshold_factor}{\link{numeric} (\emph{with default}):
Threshold for zero-bins in the histogram. Small values mean that more peaks
are removed, but signal might be also affected by this removal.}

\item{MARGIN}{\link{integer} (\emph{with default}):
on which part the function cosmic ray removal should be applied on:
\itemize{
\item 1 = along the time axis (line by line),
\item 2 = along the wavelength axis (column by column).
}

\strong{Note:} This argument only affects methods \code{smooth}, \code{smooth.spline} and
\code{smooth_RLum}.}

\item{verbose}{\link{logical} (\emph{with default}):
enable/disable output to the terminal.}

\item{plot}{\link{logical} (\emph{with default}):
If \code{TRUE} the histograms used for the cosmic-ray removal are returned as plot
including the used threshold. Note: A separate plot is returned for each frame!
Currently only for \code{method = "Pych"} a graphical output is provided.}

\item{...}{further arguments and graphical parameters that will be passed
to the \link[stats:smooth]{stats::smooth}, \link[stats:smooth.spline]{stats::smooth.spline} or \link{smooth_RLum}. See details for more
information.}
}
\value{
Returns same object as input.
}
\description{
The function provides several methods for cosmic-ray removal and spectrum
smoothing for \linkS4class{RLum.Data.Spectrum} objects, and those embedded in
\link{list} or \linkS4class{RLum.Analysis} objects.
}
\details{
\strong{\code{method = "Pych"}}

This method applies the cosmic-ray removal algorithm described by Pych
(2003). There are some differences with respect to the publication:
\itemize{
\item For interpolation between neighbouring values, the median is used instead
of the mean.
\item The number of breaks in the histogram is set to half the number of the
input values.
}

For further details see references below.

\strong{Other methods}
Arguments supported through \code{...}
\tabular{llll}{
METHOD \tab ARGUMENT \tab TYPE \tab REMARKS\cr
\code{"smooth"} \tab \code{kind} \tab  \link{character} \tab see \link[stats:smooth]{stats::smooth} \cr
\tab \code{twiceit} \tab  \link{logical} \tab see \link[stats:smooth]{stats::smooth} \cr
\code{"smooth.spline"} \tab \code{spar} \tab  \link{numeric} \tab see \link[stats:smooth.spline]{stats::smooth.spline} \cr
\code{"smooth_RLum"} \tab \code{k} \tab \link{numeric} \tab see \link{smooth_RLum}\cr
\tab \code{fill} \tab \link{numeric} \tab see \link{smooth_RLum}\cr
\tab \code{align} \tab \link{character} \tab see \link{smooth_RLum}\cr
\tab \code{method_smooth_RLum} \tab \link{character} \tab see \link{smooth_RLum}\cr
}

\strong{Best practice}

There is no single silver-bullet strategy for cosmic-ray removal, as it depends
on the characteristic of the detector and the chosen settings. For instance,
high values for pixel binning will improve the light output, but also cause
multiple pixels to be affected by a single cosmic ray. The same is valid for
longer integration times. The best strategy is to combine methods and ensure
that the spectrum is not distorted on a case-to-case basis.

\strong{How to combine methods?}

Different methods can be combined by applying the method repeatedly to the
dataset (see example).
}
\section{Function version}{
 0.4.1
}

\examples{

##(1) - use with your own data and combine (uncomment for usage)
## run two times the default method and smooth with another method
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "Pych")
## your.spectrum <- apply_CosmicRayRemoval(your.spectrum, method = "smooth")

} 

\section{How to cite}{
Kreutzer, S., 2025. apply_CosmicRayRemoval(): Cosmic-ray removal and spectrum smoothing for RLum.Data.Spectrum objects. Function version 0.4.1. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\references{
Pych, W., 2004. A Fast Algorithm for Cosmic-Ray Removal from
Single Images. The Astronomical Society of the Pacific 116 (816), 148-153.
\doi{10.1086/381786}
}
\seealso{
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}, \link[stats:smooth]{stats::smooth},
\link[stats:smooth.spline]{stats::smooth.spline}, \link{smooth_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{manip}
