% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-CV.R
\name{PLR.CV}
\alias{PLR.CV}
\title{Cross-validation for penalized Lorenz regression}
\usage{
PLR.CV(object, k, seed.CV = NULL, parallel = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{"PLR"}, i.e., the result of a call to \code{\link{Lorenz.Reg}} where \code{penalty} is either \code{"SCAD"} or \code{"LASSO"}.}

\item{k}{An integer specifying the number of folds in the k-fold cross-validation.}

\item{seed.CV}{An optional integer specifying a seed for reproducibility in the creation of the folds. Default is \code{NULL}, in which case no seed is imposed.}

\item{parallel}{A logical or numeric value controlling parallel computation. If \code{TRUE}, parallel processing is enabled using the maximum available cores minus one. If a numeric value is provided, it specifies the number of cores to use. Default is \code{FALSE} (no parallelization).}

\item{...}{Additional arguments passed to either the cross-validation function \code{\link[rsample]{vfold_cv}} from the \pkg{rsample} package or the underlying fit functions (\code{\link{Lorenz.GA}}, \code{\link{Lorenz.FABS}}, or \code{\link{Lorenz.SCADFABS}}). By default, the fit function uses the same parameters as in the original call to \code{Lorenz.Reg}, but these can be overridden by explicitly passing them in \code{...}.}
}
\value{
An object of class \code{c("PLR_cv", "PLR")}.
The returned list contains the following components:
\describe{
   \item{\code{path}}{See \code{\link{Lorenz.Reg}} for the original path. The cross-validation score is added.}
   \item{\code{lambda.idx}}{A vector indicating the index of the optimal lambda obtained by each selection method.}
   \item{\code{grid.idx}}{A vector indicating the index of the optimal grid parameter obtained by each selection method.}
   \item{\code{splits}}{A list storing the data splits used for cross-validation, as generated by \code{\link[rsample]{vfold_cv}}.}
}
Note: The returned object may have additional classes such as \code{"PLR_boot"} if bootstrap was performed.
}
\description{
\code{PLR.CV} performs k-fold cross-validation to select the grid and penalization parameters of the penalized Lorenz regression.
}
\details{
The parameter \code{seed.CV} allows for local seed setting to control randomness in the generation of the folds.
The specified seed is applied to the respective part of the computation, and the seed is reverted to its previous state after the operation.
This ensures that the seed settings do not interfere with the global random state or other parts of the code.
}
\section{References}{

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024). A penalised bootstrap estimation procedure for the explained Gini coefficient. \emph{Electronic Journal of Statistics 18(1) 247-300}.
}

\examples{
\dontshow{
utils::example(Lorenz.Reg, echo = FALSE)
}
# Continuing the Lorenz.Reg(.) example:
PLR_CV <- PLR.CV(PLR, k = 5, seed.CV = 123)
# The object now inherits from the class "PLR_cv".
# Hence the methods (also) display the results obtained by cross-validation.
print(PLR_CV)
summary(PLR_CV)
coef(PLR_CV, pars.idx = "CV")
predict(PLR_CV, pars.idx = "CV")
plot(PLR_CV)
plot(PLR_CV, type = "diagnostic") # Plot of the scores depending on the grid and penalty parameters

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Lorenz.SCADFABS}}, \code{\link{Lorenz.FABS}}, \code{\link{Lorenz.boot}}
}
