% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.logforest.R
\name{predict.logforest}
\alias{predict.logforest}
\title{Predict Outcomes Using a Logic Forest Model}
\usage{
\method{predict}{logforest}(object, newdata, cutoff, ...)
}
\arguments{
\item{object}{An object of class \code{"logforest"}.}

\item{newdata}{A matrix or data frame of new predictor values. If omitted, predictions
are made for the original data used to fit the model (OOB predictions).}

\item{cutoff}{A numeric value between 0 and 1 specifying the minimum proportion of trees
that must predict a class of 1 for the overall prediction to be 1. Ignored for non-classification models.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{"LFprediction"} containing:
\itemize{
\item \code{LFprediction}: numeric vector of predicted responses.
\item \code{proportion_one}: numeric vector of the proportion of trees predicting class 1 (classification only).
\item \code{AllTrees}: matrix or data frame with predicted values from each tree,
the proportion of trees predicting 1, and the overall predicted class (classification),
or predicted values for regression/time-to-event models.
}
}
\description{
Computes predicted values for new observations or the out-of-bag (OOB) predictions
for a logic forest model fitted using \code{logforest}.
}
\details{
For classification models, predictions are determined based on the \code{cutoff} proportion.
For regression or time-to-event models, the function returns predicted values and OOB statistics if \code{newdata} is not provided.
}
\seealso{
\code{\link{logforest}}
}
\author{
Bethany Wolf \email{wolfb@musc.edu}
}
