#' Run the LifeTableBuilder 'shiny' application
#'
#' Launches the 'shiny' application shipped with the package.
#'
#' @param ... Passed to shiny::runApp().
#' @return No return value; called for its side effects (launches a 'shiny' application).
#' @export
#'
#' @examples
#' if (interactive()) {
#'   LifeTableBuilder::run_app()
#' }
run_app <- function(...) {
  
  if (!interactive()) {
    stop("run_app() is intended for interactive use only.", call. = FALSE)
  }
  
  app_dir <- system.file("shiny", package = "LifeTableBuilder")
  
  if (app_dir == "") {
    stop("Could not find the Shiny app directory. Reinstall the package.",
         call. = FALSE)
  }
  
  shiny::runApp(app_dir, ...)
}
