% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_custom_agent.R
\name{build_custom_multi_agent}
\alias{build_custom_multi_agent}
\title{Build a Custom Multi-Agent Team (Supervisor Style)}
\usage{
build_custom_multi_agent(
  supervisor,
  workers,
  finish_token = "FINISH",
  max_turns = 10L,
  allow_repeat = FALSE,
  worker_error_policy = c("return_to_supervisor", "stop"),
  default_state = list(),
  checkpointer = NULL,
  output = c("agent", "mermaid", "both"),
  direction = c("TD", "LR"),
  subgraphs = NULL,
  style = TRUE
)
}
\arguments{
\item{supervisor}{Function that accepts `state` and returns:
- worker name (character scalar), or
- list with `next`, optionally additional updates.}

\item{workers}{Named list of workers. Each worker can be:
- a function that accepts `state` and returns a named list of updates, or
- a compiled custom-agent object with a callable `$run` function (for
  example from [build_custom_agent()] with `output = "both"` or
  [compile_graph()]).}

\item{finish_token}{Character label used by the supervisor to terminate.}

\item{max_turns}{Maximum worker turns before forcing finish.}

\item{allow_repeat}{Logical; allow the same worker twice in a row.}

\item{worker_error_policy}{`"return_to_supervisor"` (default) or `"stop"`.}

\item{default_state}{Optional defaults merged into incoming `state`.}

\item{checkpointer}{Optional callback `function(state, current_node)`.}

\item{output}{Output mode:
- `"agent"` (default): return runnable agent,
- `"mermaid"`: return Mermaid text,
- `"both"`: return list with `run`, `graph`, and `mermaid`.}

\item{direction}{Mermaid direction when `output` includes Mermaid.}

\item{subgraphs}{Optional Mermaid subgraph groups. If `NULL`, defaults to
`list(Supervisor = "supervisor", Workers = names(workers))`.}

\item{style}{Logical; include default Mermaid class styling.}
}
\value{
- If `output = "agent"`: runnable function(state).
- If `output = "mermaid"`: Mermaid text.
- If `output = "both"`: list with `run`, `graph`, and `mermaid`.
}
\description{
Build a supervisor-routed multi-agent workflow, similar to LangGraph team
orchestration. The supervisor chooses the next worker by setting `state$next`
to one of the worker names or `FINISH`.
}
\examples{
\dontrun{
supervisor_fn <- function(state) {
  if (is.null(state$turn) || state$turn == 0) "Researcher" else "FINISH"
}

workers <- list(
  Researcher = function(state) {
    list(result = "Research complete")
  },
  Writer = function(state) {
    list(result = "Draft complete")
  }
)

team <- build_custom_multi_agent(
  supervisor = supervisor_fn,
  workers = workers,
  output = "both"
)

cat(team$mermaid)
team$run(list())
}

}
