% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLOW.R
\name{FLOW}
\alias{FLOW}
\title{Class to generate a normalizing flow}
\usage{
FLOW(input_dim, transform_type, num_transforms)
}
\arguments{
\item{input_dim}{numeric vector, the dimensionality of each layer. The first item is the input vector size.}

\item{transform_type}{Type of transformation. Currently only RNVP is implemented.}

\item{num_transforms}{integer, how many layers of transformations to include in the flow.}
}
\value{
A \code{torch::nn_module} object representing the normalizing flow. The module provides:
\describe{
\item{\code{forward(z)}}{
Applies all flow transformation layers to the input tensor \code{z}.
Returns a named list containing:
\describe{
\item{\code{z}}{
A \code{torch_tensor} containing the transformed version of the input, with
the same shape as \code{z}.
}
\item{\code{logdet}}{
A scalar \code{torch_tensor} equal to the sum of the log-determinants of all
transformation layers.
}
}
}
}
}
\description{
Used in\code{LBBNN_Net} when the argument \code{flow = TRUE}.
Contains a \code{torch::nn_module} where the initial vector gets transformed through
all the layers in the module. Also computes the log-determinant of the Jacobian for the entire
transformation, which is just the sum of log-determinant of the independent layers.
}
\examples{
\donttest{
flow <- FLOW(c(200,100,100),transform_type = 'RNVP',num_transforms = 3)
flow$to(device = 'cpu')
x <- torch::torch_rand(200,device = 'cpu')
output <- flow(x)
z_out <- output$z
print(dim(z_out))
log_det <- output$logdet
print(log_det)
}
}
