% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidity.R
\name{comorbidity}
\alias{comorbidity}
\title{Comorbidity mapping}
\usage{
comorbidity(x, id, code, map, assign0, labelled = TRUE, tidy.codes = TRUE)
}
\arguments{
\item{x}{A data.frame (or data.table/tibble) containing at least an ID column and a code column.}

\item{id}{Name of the patient identifier column in `x`.}

\item{code}{Name of the diagnostic code column in `x`.}

\item{map}{Name of the mapping algorithm to use.}

\item{assign0}{Logical; if TRUE, applies hierarchy rules to avoid double-counting.}

\item{labelled}{Logical; if TRUE, adds labels for easier viewing.}

\item{tidy.codes}{Logical; if TRUE, cleans codes before mapping.}
}
\value{
A data.frame with comorbidity indicator columns and class `"comorbidity"`.
}
\description{
Maps ICD diagnostic codes to comorbidity categories using supported algorithms.
}
\examples{
x <- data.frame(
  id = c(1, 1, 2, 2),
  code = c("I10", "E119", "F200", "E110"),
  stringsAsFactors = FALSE
)

comorbidity(x = x, id = "id", code = "code",
            map = "charlson_icd10_quan", assign0 = FALSE)

comorbidity(x = x, id = "id", code = "code",
            map = "elixhauser_icd10_quan", assign0 = FALSE)
}
