% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{score.variant.status}
\alias{score.variant.status}
\title{Take the dataframe with variants and status and determine which indivudals
are scored correctly and which are scored incorrectly.
Assign an A.c, A.i, U.c, U.i, unk}
\usage{
score.variant.status(indiv.df, theoretical.max = FALSE)
}
\arguments{
\item{indiv.df}{A dataframe with the format:
name             status    variant
MS-5678-1001      A      0/1}

\item{theoretical.max}{Should the theoretical maxima be returned instead of the observed values?
When true, the scoring assumes correct variant-status pair for each individual.
Default is FALSE.}
}
\value{
Copy of input dataframe, with dataframe with the status categroies added as a new column "statvar.cat"
}
\description{
Variants can be encoded as binary (0 or 1, genotypes 0/0 or 0/1, or phased genotypes 0|0 0|1).
Note the program assumes alt is the disease allele. homozygous alts are allowed.
}
\details{
theoretical.max - bool, default is FALSE
when TRUE, function encodes the theoretical max,
using a dummy perfect associatng variant generated to see what a family could score.
TODO - switch to numbers 1-4 and -1?
}
