% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{create_quality_control_dataset}
\alias{create_quality_control_dataset}
\title{Experiment quality control}
\usage{
create_quality_control_dataset(
  dat,
  protein = dat[["Protein"]][1],
  state_1 = unique(dat[["State"]])[1],
  state_2 = unique(dat[["State"]])[2],
  time_t = unique(dat[["Exposure"]])[2],
  time_0 = min(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state_1}{first biological state.}

\item{state_2}{second biological state.}

\item{time_t}{time point of the measurement for which the calculations
are done.}

\item{time_0}{minimal exchange control time point of measurement.}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
\code{\link{data.frame}} object with mean uncertainty per different 
`time_100` value. 
The values are shown as percentages.
}
\description{
Checks how the uncertainty changes in a function of maximal
exchange control time of measurement.
}
\details{
The function calculates mean uncertainty of all peptides and its 
uncertainty (standard error) based on given `time_0` and `time_t` 
as a function of `time_100`. Both theoretical and experimental results for 
each state and their difference are supplied for comparison but only 
experimental calculations depends on `time_100` variable. The results are 
either in form of fractional or absolute values depending on the `fractional` 
parameter supplied by the user. 
This data can be useful for general overview of the experiment and analyze 
of the chosen time parameters.
}
\examples{
create_quality_control_dataset(alpha_dat)    
                           
}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
\code{\link{plot_quality_control}}
\code{\link{show_quality_control_data}}
}
