% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_delta_search}
\alias{hnp_delta_search}
\title{Delta search}
\usage{
hnp_delta_search(n, level, delta)
}
\arguments{
\item{n}{Integer specifying the cardinality of the
grid set Tau (size of \code{S_it}).}

\item{level}{Numeric between 0 and 1 representing the
desired control level (alpha) for the ith under-classification error.}

\item{delta}{Numeric tolerance parameter for the confidence bound.}
}
\value{
An integer \code{k} representing the order of the
statistic that meets the
confidence requirements. Returns \code{NA} if no valid solution exists.
}
\description{
Calculate the order k of the statistic that
satisfies the given confidence requirements for
determining classification thresholds.
}
\examples{
k <- hnp_delta_search(n = 100, level = 0.05, delta = 0.01)

}
\references{
Lijia Wang, Y. X. Rachel Wang, Jingyi Jessica Li, and Xin Tong (2024).
"Hierarchical Neyman-Pearson Classification for Prioritizing Severe Disease
Categories in COVID-19 Patient Data."
\emph{Journal of the American Statistical Association}, 119(545), 39-51.
\doi{10.1080/01621459.2023.2270657}
}
