\name{daily_maxima}
\docType{data}
\alias{daily_maxima}
\title{Daily maxima of geomagnetic rate-of-change data from Eskdalemuir Magnetic Observatory}
\description{
A dataset containing daily block maxima of the horizontal geomagnetic field rate-of-change
at the Eskdalemuir Magnetic Observatory, Scotland, United Kingdom.
The data reflect the daily extremes of geomagnetic variability, serving as indicators
of geomagnetic disturbance over the period 1999–2022.
}
\usage{data(daily_maxima)}
\format{
A numeric vector of daily maxima of
\deqn{R_1(t) = \sqrt{(X_t - X_{t-1})^2 + (Y_t - Y_{t-1})^2},}
where \eqn{X_t} and \eqn{Y_t} denote the horizontal north and east components of the magnetic field, respectively.
}
\details{
These daily maxima capture short-term geomagnetic disturbances while maintaining a sufficiently
fine temporal resolution to observe rapid changes. Like the weekly maxima, they are naturally
modelled using the Generalised Extreme Value (GEV) distribution, with location, scale, and shape
parameters \eqn{\mu}, \eqn{\sigma}, and \eqn{\xi}.
}
\source{
Eskdalemuir Magnetic Observatory, British Geological Survey, United Kingdom.

Derived and aggregated for use in \pkg{HMMHSMM}.
}
\examples{
data(daily_maxima)
plot(daily_maxima, type = "l", main = "Daily maxima of geomagnetic variability",
     ylab = "Daily maximum rate of change (nT/min)", xlab = "Day index")
}

