% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_angle.R
\name{critical_angle}
\alias{critical_angle}
\title{Compute the critical angle for the test of the angle between two
multivariate vectors}
\usage{
critical_angle(dimensions, alpha = 0.05, prec = "normal")
}
\arguments{
\item{dimensions}{number of dimensions to use}

\item{alpha}{significance level (by default 0.05)}

\item{prec}{whether one has to use the internal R functions
("normal", default), or mpfr precision ("mpfr")}
}
\value{
The function outputs the critical angle (in degrees)
}
\description{
This function computes the angle below which two vectors would be
"significantly similar" using Li 2011 test.
}
\details{
This function considers the formulas in Li 2011 which have been
used to perform a test of the angle between multivariate vectors.
This is the test implemented in MorphoJ (Klingenberg 2011),
in the R package Morpho (Schlager 2016), and in the function
TestOfAngle of this package.
The test produces a p value for the angle between two vectors
(with significant values being "significantly similar").

This function reverts the logic of the formula/test and, given a
number of dimensions (e.g., morphometric variables) and a level
of significance (by default 0.05),
it computes the angle below which the test would be significant.
}
\section{Notice}{

In case of very many dimensions, there are numerical problems in
performing the test.
If prec="normal" the function uses internally the package Morpho
(which should be installed) and these problems will start occurring
above about 340 variables.
If prec="mpfr" the function uses internally a custom function which
requires the package Rmpfr (which should be installed).
This allows the computation of extremely large or small numbers, it
is currently set to a 120 bit precision and allows the computation
using up to about 1200 variables (over this number, there will be
problems even using the option "mpfr")
}

\examples{

critical_angle(50)
# This is the angle below which two vectors (e.g., PCA axes)
# of 50 variables would be would be "significantly similar"

}
\references{
Klingenberg CP. 2011. MorphoJ: an integrated software
package for geometric morphometrics. Mol Ecol Resour 11:353-357.

Li S. 2011. Concise formulas for the area and volume of
a hyperspherical cap. Asian Journal of Mathematics and Statistics
4:66-70.

Schlager S. 2016. Morpho: Calculations and
Visualisations Related to Geometric Morphometrics.
}
\seealso{
\code{\link{TestOfAngle}}
}
