% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_val.R
\name{hill_val}
\alias{hill_val}
\title{Hill model response}
\usage{
hill_val(conc, max, AC50, n)
}
\arguments{
\item{conc}{concentration in regular space}

\item{max}{maximal (asymptotic) response}

\item{AC50}{concentration of half-maximal response}

\item{n}{Hill coefficient (slope)}
}
\value{
response value
}
\description{
Calculate the response for a given concentration in regular space.
}
\details{
This is a regular space version of
\href{https://cran.r-project.org/package=tcpl}{tcpl::tcplHillVal()}.

The Hill model is defined as:
\deqn{resp = \frac{max}{1 + (\frac{AC50}{conc})^{n}}}
}
\examples{
hill_val(c(0.0025, 0.01, 0.03), 1, 0.01, 1)
hill_val(c(0.05, 0.01, 0.003), 1, c(0.1, 0.01, 0.001), 2)
}
\seealso{
\code{\link{hill_conc}}
}
